/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.audit.AccessAuditResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogLoggerResourceDefinition;
import org.jboss.as.domain.management.audit.FileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.JsonAuditLogFormatterResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.SyslogAuditLogProtocolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class AuditLogXml {
    final boolean host;

    public AuditLogXml(boolean host) {
        this.host = host;
    }

    public void parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        switch (expectedNs) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        this.parseAuditLog2_0(reader, address, expectedNs, list, this.host);
    }

    private void parseAuditLog2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, boolean host) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        ModelNode auditLogAddress = address.clone().add(AccessAuditResourceDefinition.PATH_ELEMENT.getKey(), AccessAuditResourceDefinition.PATH_ELEMENT.getValue());
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        add.get("address").set(auditLogAddress);
        list.add(add);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case FORMATTERS: {
                    this.parseAuditLogFormatters2_0(reader, auditLogAddress, expectedNs, list);
                    continue block6;
                }
                case HANDLERS: {
                    this.parseAuditLogHandlers2_0(reader, auditLogAddress, expectedNs, list);
                    continue block6;
                }
                case LOGGER: {
                    this.parseAuditLogConfig2_0(reader, auditLogAddress, expectedNs, AuditLogLoggerResourceDefinition.PATH_ELEMENT, list);
                    continue block6;
                }
                case SERVER_LOGGER: {
                    if (!host) break;
                    this.parseAuditLogConfig2_0(reader, auditLogAddress, expectedNs, AuditLogLoggerResourceDefinition.HOST_SERVER_PATH_ELEMENT, list);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuditLogFormatters2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JSON_FORMATTER: {
                    this.parseFileAuditLogFormatter2_0(reader, address, expectedNs, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFileAuditLogFormatter2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("json-formatter", value);
                    continue block9;
                }
                case COMPACT: {
                    JsonAuditLogFormatterResourceDefinition.COMPACT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case DATE_FORMAT: {
                    JsonAuditLogFormatterResourceDefinition.DATE_FORMAT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case DATE_SEPARATOR: {
                    JsonAuditLogFormatterResourceDefinition.DATE_SEPARATOR.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case ESCAPE_CONTROL_CHARACTERS: {
                    JsonAuditLogFormatterResourceDefinition.ESCAPE_CONTROL_CHARACTERS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case ESCAPE_NEW_LINE: {
                    JsonAuditLogFormatterResourceDefinition.ESCAPE_NEW_LINE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case INCLUDE_DATE: {
                    JsonAuditLogFormatterResourceDefinition.INCLUDE_DATE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuditLogHandlers2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case FILE_HANDLER: {
                    this.parseFileAuditLogHandler2_0(reader, address, expectedNs, list);
                    continue block4;
                }
                case SYSLOG_HANDLER: {
                    this.parseSyslogAuditLogHandler2_0(reader, address, expectedNs, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFileAuditLogHandler2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("file-handler", value);
                    continue block7;
                }
                case MAX_FAILURE_COUNT: {
                    FileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case FORMATTER: {
                    FileAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case PATH: {
                    FileAuditLogHandlerResourceDefinition.PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case RELATIVE_TO: {
                    FileAuditLogHandlerResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseSyslogAuditLogHandler2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = Util.createAddOperation();
        list.add(add);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("syslog-handler", value);
                    continue block11;
                }
                case MAX_FAILURE_COUNT: {
                    SyslogAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case FORMATTER: {
                    SyslogAuditLogHandlerResourceDefinition.FORMATTER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case MAX_LENGTH: {
                    SyslogAuditLogHandlerResourceDefinition.MAX_LENGTH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case TRUNCATE: {
                    SyslogAuditLogHandlerResourceDefinition.TRUNCATE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SYSLOG_FORMAT: {
                    SyslogAuditLogHandlerResourceDefinition.SYSLOG_FORMAT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!add.get("address").isDefined()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        boolean protocolSet = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (protocolSet) {
                throw DomainManagementMessages.MESSAGES.onlyOneSyslogHandlerProtocol(reader.getLocation());
            }
            protocolSet = true;
            switch (element) {
                case UDP: 
                case TCP: 
                case TLS: {
                    this.parseSyslogAuditLogHandlerProtocol2_0(reader, add.get("address"), expectedNs, list, element);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSyslogAuditLogHandlerProtocol2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list, Element protocolElement) throws XMLStreamException {
        PathAddress protocolAddress = PathAddress.pathAddress((ModelNode)address.clone().add("protocol", protocolElement.getLocalName()));
        ModelNode add = Util.createAddOperation((PathAddress)protocolAddress);
        list.add(add);
        int tcpCount = reader.getAttributeCount();
        block9: for (int i = 0; i < tcpCount; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOST: {
                    SyslogAuditLogProtocolResourceDefinition.Udp.HOST.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case PORT: {
                    SyslogAuditLogProtocolResourceDefinition.Udp.PORT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block9;
                }
                case MESSAGE_TRANSFER: {
                    if (protocolElement != Element.UDP) {
                        SyslogAuditLogProtocolResourceDefinition.Tcp.MESSAGE_TRANSFER.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block9;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (protocolElement != Element.TLS) {
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        } else {
            boolean seenTrustStore = false;
            boolean seenClientCertStore = false;
            block10: while (reader.hasNext() && reader.nextTag() != 2) {
                ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                Element element = Element.forName((String)reader.getLocalName());
                switch (element) {
                    case TRUSTSTORE: {
                        if (seenTrustStore) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.TRUSTSTORE.getLocalName());
                        }
                        seenTrustStore = true;
                        this.parseSyslogTlsKeystore(reader, protocolAddress, expectedNs, list, SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.TRUSTSTORE_ELEMENT, false);
                        continue block10;
                    }
                    case CLIENT_CERT_STORE: {
                        if (seenClientCertStore) {
                            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.CLIENT_CERT_STORE.getLocalName());
                        }
                        seenClientCertStore = true;
                        this.parseSyslogTlsKeystore(reader, protocolAddress, expectedNs, list, SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.CLIENT_CERT_ELEMENT, true);
                        continue block10;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseSyslogTlsKeystore(XMLExtendedStreamReader reader, PathAddress address, Namespace expectedNs, List<ModelNode> list, PathElement storeAddress, boolean hasKeyPassword) throws XMLStreamException {
        ModelNode add = Util.createAddOperation((PathAddress)address.append(new PathElement[]{storeAddress}));
        list.add(add);
        int tcpCount = reader.getAttributeCount();
        block6: for (int i = 0; i < tcpCount; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEYSTORE_PASSWORD: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block6;
                }
                case PATH: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block6;
                }
                case RELATIVE_TO: {
                    SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block6;
                }
                case KEY_PASSWORD: {
                    if (hasKeyPassword) {
                        SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                        continue block6;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuditLogConfig2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, PathElement pathElement, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        ModelNode configAddress = address.clone().add(pathElement.getKey(), pathElement.getValue());
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        add.get("address").set(configAddress);
        list.add(add);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOG_READ_ONLY: {
                    AuditLogLoggerResourceDefinition.LOG_READ_ONLY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case LOG_BOOT: {
                    AuditLogLoggerResourceDefinition.LOG_BOOT.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case ENABLED: {
                    AuditLogLoggerResourceDefinition.ENABLED.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HANDLERS: {
                    this.parseAuditLogHandlersReference2_0(reader, configAddress, expectedNs, list);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuditLogHandlersReference2_0(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HANDLER: {
                    ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    list.add(add);
                    int count = reader.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address).add("handler", value);
                                break;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    public void writeAuditLog(XMLExtendedStreamWriter writer, ModelNode auditLog) throws XMLStreamException {
        writer.writeStartElement(Element.AUDIT_LOG.getLocalName());
        if (auditLog.hasDefined("json-formatter") && auditLog.get("json-formatter").keys().size() > 0) {
            writer.writeStartElement(Element.FORMATTERS.getLocalName());
            for (Property prop : auditLog.get("json-formatter").asPropertyList()) {
                writer.writeStartElement(Element.JSON_FORMATTER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), prop.getName());
                JsonAuditLogFormatterResourceDefinition.COMPACT.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.DATE_FORMAT.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.DATE_SEPARATOR.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.ESCAPE_CONTROL_CHARACTERS.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.ESCAPE_NEW_LINE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                JsonAuditLogFormatterResourceDefinition.INCLUDE_DATE.marshallAsAttribute(prop.getValue(), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (auditLog.hasDefined("file-handler") && auditLog.get("file-handler").keys().size() > 0 || auditLog.hasDefined("syslog-handler") && auditLog.get("syslog-handler").keys().size() > 0) {
            ModelNode handler;
            writer.writeStartElement(Element.HANDLERS.getLocalName());
            if (auditLog.hasDefined("file-handler")) {
                for (String name : auditLog.get("file-handler").keys()) {
                    writer.writeStartElement(Element.FILE_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"file-handler", name});
                    FileAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    FileAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    FileAuditLogHandlerResourceDefinition.PATH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    FileAuditLogHandlerResourceDefinition.RELATIVE_TO.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            if (auditLog.hasDefined("syslog-handler")) {
                for (String name : auditLog.get("syslog-handler").keys()) {
                    writer.writeStartElement(Element.SYSLOG_HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    handler = auditLog.get(new String[]{"syslog-handler", name});
                    SyslogAuditLogHandlerResourceDefinition.FORMATTER.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.MAX_FAILURE_COUNT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.SYSLOG_FORMAT.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.MAX_LENGTH.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    SyslogAuditLogHandlerResourceDefinition.TRUNCATE.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    if (handler.hasDefined("protocol")) {
                        this.writeAuditLogSyslogProtocol(writer, handler.get("protocol"));
                    }
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
        this.writeAuditLogger(writer, auditLog, Element.LOGGER.getLocalName());
        this.writeAuditLogger(writer, auditLog, Element.SERVER_LOGGER.getLocalName());
        writer.writeEndElement();
    }

    private void writeAuditLogger(XMLExtendedStreamWriter writer, ModelNode auditLog, String element) throws XMLStreamException {
        if (auditLog.hasDefined(element) && auditLog.get(element).hasDefined("audit-log")) {
            ModelNode config = auditLog.get(new String[]{element, "audit-log"});
            writer.writeStartElement(element);
            AuditLogLoggerResourceDefinition.LOG_BOOT.marshallAsAttribute(config, (XMLStreamWriter)writer);
            AuditLogLoggerResourceDefinition.LOG_READ_ONLY.marshallAsAttribute(config, (XMLStreamWriter)writer);
            AuditLogLoggerResourceDefinition.ENABLED.marshallAsAttribute(config, (XMLStreamWriter)writer);
            if (config.hasDefined("handler") && config.get("handler").keys().size() > 0) {
                writer.writeStartElement(Element.HANDLERS.getLocalName());
                for (String name : config.get("handler").keys()) {
                    writer.writeStartElement(Element.HANDLER.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeAuditLogSyslogProtocol(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        String type = (String)protocol.keys().iterator().next();
        ModelNode protocolContents = protocol.get(type);
        if (type.equals("udp")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Udp.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Udp.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (type.equals("tcp")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Tcp.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tcp.MESSAGE_TRANSFER.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if (type.equals("tls")) {
            writer.writeStartElement(type);
            SyslogAuditLogProtocolResourceDefinition.Tls.HOST.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tls.PORT.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.Tls.MESSAGE_TRANSFER.marshallAsAttribute(protocolContents, (XMLStreamWriter)writer);
            if (protocolContents.hasDefined("authentication")) {
                this.writeAuditLogSyslogTlsProtocolKeyStore(writer, protocolContents.get("authentication"), "truststore");
                this.writeAuditLogSyslogTlsProtocolKeyStore(writer, protocolContents.get("authentication"), "client-certificate-store");
            }
            writer.writeEndElement();
        }
    }

    private void writeAuditLogSyslogTlsProtocolKeyStore(XMLExtendedStreamWriter writer, ModelNode keystoreParent, String name) throws XMLStreamException {
        if (keystoreParent.hasDefined(name)) {
            ModelNode keystore = keystoreParent.get(name);
            writer.writeStartElement(name);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD.marshallAsAttribute(keystore, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }
}

