/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapGroupSearcher;
import org.jboss.as.domain.management.security.LdapUserSearcher;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class LdapSubjectSupplementalService
implements Service<SubjectSupplementalService>,
SubjectSupplementalService {
    private final InjectedValue<ConnectionManager> connectionManager = new InjectedValue();
    private final InjectedValue<LdapUserSearcher> userSearcherInjector = new InjectedValue();
    private final InjectedValue<LdapGroupSearcher> groupSearcherInjector = new InjectedValue();
    private LdapUserSearcher userSearcher;
    private LdapGroupSearcher groupSearcher;
    protected final int searchTimeLimit = 10000;
    private final String realmName;
    private final boolean shareConnection;
    private final boolean forceUserDnSearch;
    private final boolean iterative;
    private final BaseLdapGroupSearchResource.GroupName groupName;

    public LdapSubjectSupplementalService(String realmName, boolean shareConnection, boolean forceUserDnSearch, boolean iterative, BaseLdapGroupSearchResource.GroupName groupName) {
        this.realmName = realmName;
        this.shareConnection = shareConnection;
        this.forceUserDnSearch = forceUserDnSearch;
        this.iterative = iterative;
        this.groupName = groupName;
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.userSearcher = (LdapUserSearcher)this.userSearcherInjector.getOptionalValue();
        this.groupSearcher = (LdapGroupSearcher)this.groupSearcherInjector.getValue();
    }

    public void stop(StopContext context) {
    }

    public Injector<ConnectionManager> getConnectionManagerInjector() {
        return this.connectionManager;
    }

    public Injector<LdapUserSearcher> getLdapUserSearcherInjector() {
        return this.userSearcherInjector;
    }

    public Injector<LdapGroupSearcher> getLdapGroupSearcherInjector() {
        return this.groupSearcherInjector;
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return new LdapSubjectSupplemental(sharedState);
    }

    private void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "ldap-authorization";

        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{SERVICE_SUFFIX});
        }
    }

    public class LdapSubjectSupplemental
    implements SubjectSupplemental {
        private final Set<LdapEntry> searchedPerformed = new HashSet<LdapEntry>();
        private final Map<String, Object> sharedState;
        private DirContext dirContext = null;

        protected LdapSubjectSupplemental(Map<String, Object> sharedState) {
            this.sharedState = sharedState;
        }

        @Override
        public void supplementSubject(Subject subject) throws IOException {
            Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
            Set<Principal> principals = subject.getPrincipals();
            try {
                this.dirContext = this.getSearchContext();
                for (RealmUser current : users) {
                    principals.addAll(this.loadGroups(current));
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            finally {
                LdapSubjectSupplementalService.this.safeClose(this.dirContext);
                this.dirContext = null;
            }
        }

        private Set<RealmGroup> loadGroups(RealmUser user) throws IOException, NamingException {
            LdapEntry entry = null;
            if (!LdapSubjectSupplementalService.this.forceUserDnSearch && this.sharedState.containsKey(LdapEntry.class.getName())) {
                entry = (LdapEntry)this.sharedState.get(LdapEntry.class.getName());
            }
            if (entry == null || !user.getName().equals(entry.getSimpleName())) {
                entry = LdapSubjectSupplementalService.this.userSearcher.userSearch(this.dirContext, user.getName());
            }
            return this.loadGroups(entry);
        }

        private Set<RealmGroup> loadGroups(LdapEntry entry) throws IOException, NamingException {
            HashSet<RealmGroup> realmGroups = new HashSet<RealmGroup>();
            Stack<LdapEntry[]> entries = new Stack<LdapEntry[]>();
            entries.push(this.loadGroupEntries(entry));
            while (!entries.isEmpty()) {
                LdapEntry[] found;
                for (LdapEntry current : found = (LdapEntry[])entries.pop()) {
                    realmGroups.add(new RealmGroup(LdapSubjectSupplementalService.this.realmName, LdapSubjectSupplementalService.this.groupName == BaseLdapGroupSearchResource.GroupName.SIMPLE ? current.getSimpleName() : current.getDistinguishedName()));
                    if (!LdapSubjectSupplementalService.this.iterative) continue;
                    entries.push(this.loadGroupEntries(current));
                }
            }
            return realmGroups;
        }

        private LdapEntry[] loadGroupEntries(LdapEntry entry) throws IOException, NamingException {
            if (!this.searchedPerformed.add(entry)) {
                return new LdapEntry[0];
            }
            return LdapSubjectSupplementalService.this.groupSearcher.groupSearch(this.dirContext, entry);
        }

        private DirContext getSearchContext() throws Exception {
            DirContext searchContext;
            if (LdapSubjectSupplementalService.this.shareConnection && this.sharedState.containsKey(DirContext.class.getName())) {
                searchContext = (DirContext)this.sharedState.remove(DirContext.class.getName());
            } else {
                ConnectionManager connectionManager = (ConnectionManager)LdapSubjectSupplementalService.this.connectionManager.getValue();
                searchContext = (DirContext)connectionManager.getConnection();
            }
            return searchContext;
        }
    }
}

