/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import javax.enterprise.inject.spi.Bean;
import org.jboss.as.weld.injection.InterceptedNonContextualComponentInjectionTarget;
import org.jboss.as.weld.injection.NonContextualComponentInjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;

public class InjectionTargets {
    private InjectionTargets() {
    }

    public static <T> BasicInjectionTarget<T> createInjectionTarget(Class<?> componentClass, Bean<T> bean, BeanManagerImpl beanManager, boolean interceptionSupport) {
        ClassTransformer transformer = (ClassTransformer)beanManager.getServices().get(ClassTransformer.class);
        EnhancedAnnotatedType type = transformer.getEnhancedAnnotatedType(componentClass, beanManager.getId());
        if (Beans.getBeanConstructor((EnhancedAnnotatedType)type) == null) {
            return new NonProducibleInjectionTarget(type, bean, beanManager);
        }
        if (interceptionSupport) {
            return new InterceptedNonContextualComponentInjectionTarget<T>(type, bean, beanManager);
        }
        return new NonContextualComponentInjectionTarget<T>(type, bean, beanManager);
    }
}

