/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public abstract class Protocol {
    protected Protocol up_prot;
    protected Protocol down_prot;
    protected ProtocolStack stack;
    @Property(description="Determines whether to collect statistics (and expose them via JMX). Default is true", writable=true)
    protected boolean stats = true;
    @Property(description="Enables ergonomics: dynamically find the best values for properties at runtime")
    protected boolean ergonomics = true;
    @Property(name="name", description="Give the protocol a different name if needed so we can have multiple instances of it in the same stack (also change ID)", writable=false)
    protected String name = this.getClass().getSimpleName();
    @Property(description="Give the protocol a different ID if needed so we can have multiple instances of it in the same stack", writable=false)
    protected short id = ClassConfigurator.getProtocolId(this.getClass());
    protected final Log log = LogFactory.getLog(this.getClass());

    @Property(name="level", description="Sets the logger level (see javadocs)")
    public void setLevel(String level) {
        this.log.setLevel(level);
    }

    public String getLevel() {
        return this.log.getLevel();
    }

    public Protocol level(String level) {
        this.log.setLevel(level);
        return this;
    }

    public boolean isErgonomics() {
        return this.ergonomics;
    }

    public void setErgonomics(boolean ergonomics) {
        this.ergonomics = ergonomics;
    }

    public ProtocolStack getProtocolStack() {
        return this.stack;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public String getName() {
        return this.name;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol prot) {
        this.up_prot = prot;
    }

    public void setDownProtocol(Protocol prot) {
        this.down_prot = prot;
    }

    public void setProtocolStack(ProtocolStack s) {
        this.stack = s;
    }

    public Object getValue(String name) {
        if (name == null) {
            return null;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field \"" + name + "\n not found");
        }
        return Util.getField(field, this);
    }

    public Protocol setValues(Map<String, Object> values) {
        if (values == null) {
            return this;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String attrname = entry.getKey();
            Object value = entry.getValue();
            Field field = Util.getField(this.getClass(), attrname);
            if (field == null) continue;
            Util.setField(field, this, value);
        }
        return this;
    }

    public Protocol setValue(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field \"" + name + "\n not found");
        }
        Util.setField(field, this, value);
        return this;
    }

    protected List<Object> getConfigurableObjects() {
        return null;
    }

    public short[] getIdsAbove() {
        ArrayList<Short> ids = new ArrayList<Short>();
        Protocol current = this.up_prot;
        while (current != null) {
            ids.add(current.getId());
            current = current.up_prot;
        }
        short[] retval = new short[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            retval[i] = (Short)ids.get(i);
        }
        return retval;
    }

    protected TP getTransport() {
        Protocol retval = this;
        while (retval != null && retval.down_prot != null) {
            retval = retval.down_prot;
        }
        return (TP)retval;
    }

    public ThreadFactory getThreadFactory() {
        return this.down_prot != null ? this.down_prot.getThreadFactory() : null;
    }

    public SocketFactory getSocketFactory() {
        return this.down_prot != null ? this.down_prot.getSocketFactory() : null;
    }

    public void setSocketFactory(SocketFactory factory) {
        if (this.down_prot != null) {
            this.down_prot.setSocketFactory(factory);
        }
    }

    @ManagedOperation(description="Resets all stats")
    public void resetStatistics() {
        this.resetStats();
    }

    public void resetStats() {
    }

    public String printStats() {
        return null;
    }

    public Map<String, Object> dumpStats() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ManagedAttribute.class) && (!field.isAnnotationPresent(Property.class) || !field.getAnnotation(Property.class).exposeAsManagedAttribute())) continue;
                ManagedAttribute attr_annotation = field.getAnnotation(ManagedAttribute.class);
                Property prop = field.getAnnotation(Property.class);
                String attr_name = attr_annotation != null ? attr_annotation.name() : (prop != null ? prop.name() : null);
                attr_name = attr_name != null && !attr_name.trim().isEmpty() ? attr_name.trim() : field.getName();
                try {
                    field.setAccessible(true);
                    Object value = field.get(this);
                    map.put(attr_name, value != null ? value.toString() : null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (field) " + attr_name, e);
                }
            }
            for (Method method : methods = this.getClass().getMethods()) {
                String method_name;
                if (!method.isAnnotationPresent(ManagedAttribute.class) && (!method.isAnnotationPresent(Property.class) || !method.getAnnotation(Property.class).exposeAsManagedAttribute())) continue;
                ManagedAttribute attr_annotation = method.getAnnotation(ManagedAttribute.class);
                Property prop = method.getAnnotation(Property.class);
                String string = attr_annotation != null ? attr_annotation.name() : (method_name = prop != null ? prop.name() : null);
                if (method_name != null && !method_name.trim().isEmpty()) {
                    method_name = method_name.trim();
                } else {
                    String field_name = Util.methodNameToAttributeName(method.getName());
                    method_name = Util.attributeNameToMethodName(field_name);
                }
                if (!ResourceDMBean.isGetMethod(method)) continue;
                try {
                    Object value = method.invoke((Object)this, new Object[0]);
                    String attributeName = Util.methodNameToAttributeName(method_name);
                    map.put(attributeName, value != null ? value.toString() : null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (method) " + method_name, e);
                }
            }
        }
        return map;
    }

    public void init() throws Exception {
        short real_id = ClassConfigurator.getProtocolId(this.getClass());
        if (real_id > 0 && this.id != real_id) {
            this.name = this.name + "-" + this.id;
        }
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public List<Integer> requiredUpServices() {
        return null;
    }

    public List<Integer> requiredDownServices() {
        return null;
    }

    public List<Integer> providedUpServices() {
        return null;
    }

    public List<Integer> providedDownServices() {
        return null;
    }

    public final List<Integer> getDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Protocol prot = this.down_prot;
        while (prot != null) {
            List<Integer> tmp = prot.providedUpServices();
            if (tmp != null && !tmp.isEmpty()) {
                retval.addAll(tmp);
            }
            prot = prot.down_prot;
        }
        return retval;
    }

    public final List<Integer> getUpServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        Protocol prot = this.up_prot;
        while (prot != null) {
            List<Integer> tmp = prot.providedDownServices();
            if (tmp != null && !tmp.isEmpty()) {
                retval.addAll(tmp);
            }
            prot = prot.up_prot;
        }
        return retval;
    }

    public Object up(Event evt) {
        return this.up_prot.up(evt);
    }

    protected boolean accept(Message msg) {
        short tmp_id = this.getId();
        return tmp_id > 0 && msg.getHeader(tmp_id) != null;
    }

    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (msg == null || !this.accept(msg)) continue;
            it.remove();
            try {
                this.up(new Event(1, msg));
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("PassUpFailure"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }
}

