/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.jca.adapters.jdbc.extensions.oracle.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;

public class OracleReauthPlugin
implements ReauthPlugin {
    @Override
    public synchronized void initialize(ClassLoader cl) throws SQLException {
        Class<?> oracleConnection = null;
        try {
            oracleConnection = Class.forName("oracle.jdbc.OracleConnection", true, cl);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (oracleConnection == null) {
            try {
                oracleConnection = Class.forName("oracle.jdbc.OracleConnection", true, this.getClass().getClassLoader());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (oracleConnection == null) {
            try {
                ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
                oracleConnection = Class.forName("oracle.jdbc.OracleConnection", true, tccl);
            }
            catch (Throwable t) {
                throw new SQLException("Cannot resolve oracle.jdbc.OracleConnection", t);
            }
        }
        try {
            oracleConnection.getMethod("openProxySession", Integer.TYPE, Properties.class);
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve oracle.jdbc.OracleConnection openProxySession method", t);
        }
        try {
            oracleConnection.getField("PROXYTYPE_USER_NAME");
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve oracle.jdbc.OracleConnection PROXYTYPE_USER_NAME field", t);
        }
        try {
            oracleConnection.getField("PROXY_USER_NAME");
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve oracle.jdbc.OracleConnection PROXY_USER_NAME field", t);
        }
        try {
            oracleConnection.getField("PROXY_USER_PASSWORD");
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve oracle.jdbc.OracleConnection PROXY_USER_PASSWORD field", t);
        }
    }

    @Override
    public synchronized void reauthenticate(Connection c, String userName, String password) throws SQLException {
        try {
            int proxyTypeUserName = c.getClass().getField("PROXYTYPE_USER_NAME").getInt(c);
            String proxyUserName = (String)c.getClass().getField("PROXY_USER_NAME").get(c);
            String proxyPassword = (String)c.getClass().getField("PROXY_USER_PASSWORD").get(c);
            Properties props = new Properties();
            props.put(proxyUserName, userName);
            if (password != null) {
                props.put(proxyPassword, password);
            }
            Object[] params = new Object[]{proxyTypeUserName, props};
            Method openProxySession = c.getClass().getMethod("openProxySession", Integer.TYPE, Properties.class);
            SecurityActions.setAccessible(openProxySession);
            openProxySession.invoke((Object)c, params);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException("Unexpected error in openProxySession", t);
        }
    }
}

