/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;

public class ProtectionToken
extends TokenWrapper {
    public ProtectionToken(PolicyBuilder b) {
        super(SP12Constants.INSTANCE, b);
    }

    public ProtectionToken(SPConstants version, PolicyBuilder b) {
        super(version, b);
    }

    public Token getProtectionToken() {
        return this.getToken();
    }

    public void setProtectionToken(Token protectionToken) {
        this.setToken(protectionToken);
    }

    public QName getRealName() {
        return this.constants.getProtectionToken();
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getProtectionToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String prefix;
        String localname = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        String policyLocalName = SPConstants.POLICY.getLocalPart();
        String policyNamespaceURI = SPConstants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = SPConstants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
        if (wspWriterPrefix == null) {
            writer.writeNamespace(wspPrefix, policyNamespaceURI);
        }
        if (this.token == null) {
            throw new RuntimeException("ProtectionToken is not set");
        }
        this.token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

