/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    protected final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentFullReplaceHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentFullReplaceHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentFullReplaceHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        byte[] newHash;
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        final String name = DeploymentAttributes.NAME.resolveModelAttribute(context, operation).asString();
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        String runtimeName = operation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? operation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        ModelNode content = operation.require("content").clone();
        ModelNode deploymentModel = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath})).getModel();
        String replacedRuntimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, deploymentModel).asString();
        ModelNode replacedContent = deploymentModel.get("content").get(0);
        final byte[] replacedHash = replacedContent.hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, replacedContent).asBytes() : null;
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            newHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
            contentItem = this.addFromHash(newHash);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, contentItemNode);
            newHash = contentItem.getHash();
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(newHash);
            content.clear();
            content.add(contentItemNode);
        } else {
            contentItem = this.addUnmanaged(context, contentItemNode);
            newHash = null;
        }
        deploymentModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        deploymentModel.get("content").set(content);
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deploymentModel).asBoolean()) {
            DeploymentHandlerUtil.replace(context, deploymentModel, runtimeName, name, replacedRuntimeName, this.vaultReader, contentItem);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(replacedHash == null || newHash != null && Arrays.equals(replacedHash, newHash))) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(replacedHash, (Object)name);
                    }
                    if (newHash != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.addContentReference(newHash, (Object)name);
                    }
                } else if (!(newHash == null || replacedHash != null && Arrays.equals(replacedHash, newHash))) {
                    DeploymentFullReplaceHandler.this.contentRepository.removeContent(newHash, (Object)name);
                }
            }
        });
    }

    DeploymentHandlerUtil.ContentItem addFromHash(byte[] hash) throws OperationFailedException {
        if (!this.contentRepository.syncContent(hash)) {
            throw ServerMessages.MESSAGES.noSuchDeploymentContent(HashUtil.bytesToHexString((byte[])hash));
        }
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        contentItemNode.clear();
        contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(hash);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        String path = DeploymentAttributes.CONTENT_PATH.resolveModelAttribute(context, contentItemNode).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = DeploymentAttributes.CONTENT_ARCHIVE.resolveModelAttribute(context, contentItemNode).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

