/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.service;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceActivatorContextImpl;
import org.jboss.msc.service.ServiceRegistryException;

public class ServiceActivatorProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ServicesAttachment servicesAttachment = deploymentUnit.getAttachment(Attachments.SERVICES);
        if (servicesAttachment == null || servicesAttachment.getServiceImplementations(ServiceActivator.class.getName()).isEmpty()) {
            return;
        }
        Module module = deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ServiceActivatorContextImpl serviceActivatorContext = new ServiceActivatorContextImpl(phaseContext.getServiceTarget(), phaseContext.getServiceRegistry());
        for (ServiceActivator serviceActivator : module.loadService(ServiceActivator.class)) {
            try {
                serviceActivator.activate((ServiceActivatorContext)serviceActivatorContext);
            }
            catch (ServiceRegistryException e) {
                throw new DeploymentUnitProcessingException(e);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

