/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.paging.cursor.PageCursorProvider;
import org.hornetq.core.paging.cursor.impl.LivePageCacheImpl;
import org.hornetq.core.paging.cursor.impl.PageCursorProviderImpl;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.paging.impl.PageSyncTimer;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.paging.impl.PagedMessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.RouteContextList;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.utils.FutureLatch;

public class PagingStoreImpl
implements PagingStore {
    private final SimpleString address;
    private final StorageManager storageManager;
    private final DecimalFormat format = new DecimalFormat("000000000");
    private final AtomicInteger currentPageSize = new AtomicInteger(0);
    private final SimpleString storeName;
    private volatile SequentialFileFactory fileFactory;
    private final PagingStoreFactory storeFactory;
    private final PageSyncTimer syncTimer;
    private long maxSize;
    private long pageSize;
    private volatile AddressFullMessagePolicy addressFullMessagePolicy;
    private boolean printedDropMessagesWarning;
    private final PagingManager pagingManager;
    private final Executor executor;
    private final AtomicLong sizeInBytes = new AtomicLong();
    private volatile int numberOfPages;
    private volatile int firstPageId;
    private volatile int currentPageId;
    private volatile Page currentPage;
    private volatile boolean paging = false;
    private final PageCursorProvider cursorProvider;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    private final boolean syncNonTransactional;
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final Queue<OurRunnable> onMemoryFreedRunnables = new ConcurrentLinkedQueue<OurRunnable>();
    private final Runnable memoryFreedRunnablesExecutor = new MemoryFreedRunnablesExecutor();

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, Executor executor, boolean syncNonTransactional) {
        if (pagingManager == null) {
            throw new IllegalStateException("Paging Manager can't be null");
        }
        this.address = address;
        this.storageManager = storageManager;
        this.storeName = storeName;
        this.applySetting(addressSettings);
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE && this.maxSize != -1L && this.pageSize >= this.maxSize) {
            throw new IllegalStateException("pageSize for address " + address + " >= maxSize. Normally pageSize should" + " be significantly smaller than maxSize, ms: " + this.maxSize + " ps " + this.pageSize);
        }
        this.executor = executor;
        this.pagingManager = pagingManager;
        this.fileFactory = fileFactory;
        this.storeFactory = storeFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.syncTimer = scheduledExecutor != null ? new PageSyncTimer(this, scheduledExecutor, syncTimeout) : null;
        this.cursorProvider = new PageCursorProviderImpl(this, this.storageManager, executor, addressSettings.getPageCacheMaxSize());
    }

    @Override
    public void applySetting(AddressSettings addressSettings) {
        this.maxSize = addressSettings.getMaxSizeBytes();
        this.pageSize = addressSettings.getPageSizeBytes();
        this.addressFullMessagePolicy = addressSettings.getAddressFullMessagePolicy();
        if (this.cursorProvider != null) {
            this.cursorProvider.setCacheMaxSize(addressSettings.getPageCacheMaxSize());
        }
    }

    public String toString() {
        return "PagingStoreImpl(" + this.address + ")";
    }

    @Override
    public boolean lock(long timeout) {
        if (timeout == -1L) {
            this.lock.writeLock().lock();
            return true;
        }
        try {
            return this.lock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void unlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public PageCursorProvider getCursorProvider() {
        return this.cursorProvider;
    }

    @Override
    public long getFirstPage() {
        return this.firstPageId;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getAddressSize() {
        return this.sizeInBytes.get();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    @Override
    public long getPageSizeBytes() {
        return this.pageSize;
    }

    @Override
    public String getFolder() {
        SequentialFileFactory factoryUsed = this.fileFactory;
        if (factoryUsed != null) {
            return factoryUsed.getDirectory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaging() {
        this.lock.readLock().lock();
        try {
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
                boolean bl = false;
                return bl;
            }
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
                boolean bl = this.isFull();
                return bl;
            }
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP) {
                boolean bl = this.isFull();
                return bl;
            }
            boolean bl = this.paging;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public int getCurrentWritingPage() {
        return this.currentPageId;
    }

    @Override
    public SimpleString getStoreName() {
        return this.storeName;
    }

    @Override
    public void sync() throws Exception {
        if (this.syncTimer != null) {
            this.syncTimer.addSync(this.storageManager.getContext());
        } else {
            this.ioSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ioSync() throws Exception {
        this.lock.readLock().lock();
        try {
            if (this.currentPage != null) {
                this.currentPage.sync();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        this.cursorProvider.processReload();
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    public boolean isStarted() {
        return this.running;
    }

    public synchronized void stop() throws Exception {
        if (this.running) {
            this.cursorProvider.stop();
            this.running = false;
            this.flushExecutors();
            if (this.currentPage != null) {
                this.currentPage.close();
                this.currentPage = null;
            }
        }
    }

    @Override
    public void flushExecutors() {
        this.cursorProvider.flushExecutors();
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        if (!future.await(60000L)) {
            HornetQServerLogger.LOGGER.pageStoreTimeout(this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.lock.writeLock().lock();
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            this.firstPageId = Integer.MAX_VALUE;
            if (this.fileFactory != null) {
                this.currentPageId = 0;
                if (this.currentPage != null) {
                    this.currentPage.close();
                }
                this.currentPage = null;
                List files = this.fileFactory.listFiles("page");
                this.numberOfPages = files.size();
                for (String fileName : files) {
                    int fileId = PagingStoreImpl.getPageIdFromFileName(fileName);
                    if (fileId > this.currentPageId) {
                        this.currentPageId = fileId;
                    }
                    if (fileId >= this.firstPageId) continue;
                    this.firstPageId = fileId;
                }
                if (this.currentPageId != 0) {
                    this.currentPage = this.createPage(this.currentPageId);
                    this.currentPage.open();
                    List<PagedMessage> messages = this.currentPage.read(this.storageManager);
                    LivePageCacheImpl pageCache = new LivePageCacheImpl(this.currentPage);
                    for (PagedMessage msg : messages) {
                        pageCache.addLiveMessage(msg);
                        if (!msg.getMessage().isLargeMessage()) continue;
                        ((LargeServerMessage)msg.getMessage()).decrementDelayDeletionCount();
                    }
                    this.currentPage.setLiveCache(pageCache);
                    this.currentPageSize.set(this.currentPage.getSize());
                    this.cursorProvider.addPageCache(pageCache);
                }
                if (this.currentPage != null && (this.numberOfPages != 1 || this.currentPage.getSize() != 0)) {
                    this.startPaging();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPaging() {
        this.lock.writeLock().lock();
        try {
            this.paging = false;
            this.cursorProvider.onPageModeCleared();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startPaging() {
        if (!this.running) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
            if (this.currentPage == null) {
                try {
                    this.openNewPage();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.pageStoreStartIOError(e);
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
            }
            this.paging = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean checkPageFileExists(int pageNumber) {
        String fileName = this.createFileName(pageNumber);
        SequentialFile file = this.fileFactory.createSequentialFile(fileName, 1);
        return file.exists();
    }

    @Override
    public Page createPage(int pageNumber) throws Exception {
        String fileName = this.createFileName(pageNumber);
        if (this.fileFactory == null) {
            this.fileFactory = this.storeFactory.newFileFactory(this.getStoreName());
        }
        SequentialFile file = this.fileFactory.createSequentialFile(fileName, 1000);
        Page page = new Page(this.storeName, this.storageManager, this.fileFactory, file, pageNumber);
        file.open();
        file.position(0L);
        file.close();
        return page;
    }

    @Override
    public void forceAnotherPage() throws Exception {
        this.openNewPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page depage() throws Exception {
        this.lock.writeLock().lock();
        try {
            Page returnPage;
            if (!this.running) {
                Page page = null;
                return page;
            }
            if (this.numberOfPages == 0) {
                Page page = null;
                return page;
            }
            --this.numberOfPages;
            if (this.currentPageId == this.firstPageId) {
                this.firstPageId = Integer.MAX_VALUE;
                if (this.currentPage == null) {
                    throw new IllegalStateException("CurrentPage is null");
                }
                Page returnPage2 = this.currentPage;
                returnPage2.close();
                this.currentPage = null;
                if (returnPage2.getNumberOfMessages() == 0) {
                    this.stopPaging();
                    returnPage2.open();
                    returnPage2.delete(null);
                    Page page = null;
                    return page;
                }
                this.openNewPage();
                Page page = returnPage2;
                return page;
            }
            Page page = returnPage = this.createPage(this.firstPageId++);
            return page;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean checkMemory(Runnable runWhenAvailable) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK && this.maxSize != -1L) {
            if (this.sizeInBytes.get() > this.maxSize) {
                OurRunnable ourRunnable = new OurRunnable(runWhenAvailable);
                this.onMemoryFreedRunnables.add(ourRunnable);
                if (this.sizeInBytes.get() <= this.maxSize) {
                    ourRunnable.run();
                }
                return true;
            }
        } else if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL && this.maxSize != -1L && this.sizeInBytes.get() > this.maxSize) {
            return false;
        }
        runWhenAvailable.run();
        return true;
    }

    @Override
    public void addSize(int size) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            long newSize;
            if (this.maxSize != -1L && (newSize = this.sizeInBytes.addAndGet(size)) <= this.maxSize && !this.onMemoryFreedRunnables.isEmpty()) {
                this.executor.execute(this.memoryFreedRunnablesExecutor);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE) {
            long addressSize = this.sizeInBytes.addAndGet(size);
            if (size > 0 && this.maxSize > 0L && addressSize > this.maxSize && this.startPaging() && isTrace) {
                HornetQServerLogger.LOGGER.pageStoreStart(this.storeName, addressSize, this.maxSize);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            this.sizeInBytes.addAndGet(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean page(ServerMessage message, Transaction tx, RouteContextList listCtx, ReentrantReadWriteLock.ReadLock managerLock) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("PagingStore(" + this.getStoreName() + ") not initialized");
        }
        boolean full = this.isFull();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (full) {
                if (!this.printedDropMessagesWarning) {
                    this.printedDropMessagesWarning = true;
                    HornetQServerLogger.LOGGER.pageStoreDropMessages(this.storeName);
                }
                if (message.isLargeMessage()) {
                    ((LargeServerMessage)message).deleteFile();
                }
                return true;
            }
            return false;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (!this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        managerLock.lock();
        try {
            int bytesToWrite;
            block25: {
                this.lock.writeLock().lock();
                try {
                    if (this.paging) break block25;
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            if (!message.isDurable()) {
                message.forceAddress(this.address);
            }
            long transactionID = tx == null ? -1L : tx.getID();
            PagedMessageImpl pagedMessage = new PagedMessageImpl(message, this.routeQueues(tx, listCtx), transactionID);
            if (message.isLargeMessage()) {
                ((LargeServerMessage)message).setPaged();
            }
            if ((long)this.currentPageSize.addAndGet(bytesToWrite = pagedMessage.getEncodeSize() + 6) > this.pageSize && this.currentPage.getNumberOfMessages() > 0) {
                this.openNewPage();
                this.currentPageSize.addAndGet(bytesToWrite);
            }
            if (tx != null) {
                this.installPageTransaction(tx, listCtx);
            }
            this.currentPage.write(pagedMessage);
            if (tx == null && this.syncNonTransactional) {
                this.sync();
            }
            if (isTrace) {
                HornetQServerLogger.LOGGER.trace("Paging message " + pagedMessage + " on pageStore " + this.getStoreName() + " pageId=" + this.currentPage.getPageId());
            }
            boolean bl = true;
            this.lock.writeLock().unlock();
            return bl;
        }
        finally {
            managerLock.unlock();
        }
    }

    @Override
    public void disableCleanup() {
        this.getCursorProvider().disableCleanup();
    }

    @Override
    public void enableCleanup() {
        this.getCursorProvider().resumeCleanup();
    }

    private long[] routeQueues(Transaction tx, RouteContextList ctx) throws Exception {
        List<org.hornetq.core.server.Queue> durableQueues = ctx.getDurableQueues();
        List<org.hornetq.core.server.Queue> nonDurableQueues = ctx.getNonDurableQueues();
        long[] ids = new long[durableQueues.size() + nonDurableQueues.size()];
        int i = 0;
        for (org.hornetq.core.server.Queue q : durableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1);
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        for (org.hornetq.core.server.Queue q : nonDurableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1);
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        return ids;
    }

    private void installPageTransaction(Transaction tx, RouteContextList listCtx) throws Exception {
        FinishPageMessageOperation pgOper = (FinishPageMessageOperation)tx.getProperty(5);
        if (pgOper == null) {
            PageTransactionInfoImpl pgTX = new PageTransactionInfoImpl(tx.getID());
            this.pagingManager.addTransaction(pgTX);
            pgOper = new FinishPageMessageOperation(pgTX, this.storageManager, this.pagingManager);
            tx.putProperty(5, pgOper);
            tx.addOperation(pgOper);
        }
        pgOper.addStore(this);
        pgOper.pageTransaction.increment(listCtx.getNumberOfDurableQueues(), listCtx.getNumberOfNonDurableQueues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewPage() throws Exception {
        this.lock.writeLock().lock();
        try {
            ++this.numberOfPages;
            int tmpCurrentPageId = this.currentPageId + 1;
            if (this.currentPage != null) {
                this.currentPage.close();
            }
            this.currentPage = this.createPage(tmpCurrentPageId);
            LivePageCacheImpl pageCache = new LivePageCacheImpl(this.currentPage);
            this.currentPage.setLiveCache(pageCache);
            this.cursorProvider.addPageCache(pageCache);
            this.currentPageSize.set(0);
            this.currentPage.open();
            this.currentPageId = tmpCurrentPageId;
            if (this.currentPageId < this.firstPageId) {
                this.firstPageId = this.currentPageId;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFileName(int pageID) {
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            return this.format.format(pageID) + ".page";
        }
    }

    private static int getPageIdFromFileName(String fileName) {
        return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
    }

    private boolean isFull() {
        return this.maxSize > 0L && this.getAddressSize() > this.maxSize;
    }

    @Override
    public Collection<Integer> getCurrentIds() throws Exception {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (this.fileFactory != null) {
            for (String fileName : this.fileFactory.listFiles("page")) {
                ids.add(PagingStoreImpl.getPageIdFromFileName(fileName));
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPages(ReplicationManager replicator, Collection<Integer> pageIds) throws Exception {
        this.lock.writeLock().lock();
        try {
            for (Integer id : pageIds) {
                SequentialFile sFile = this.fileFactory.createSequentialFile(this.createFileName(id), 1);
                if (!sFile.exists()) continue;
                replicator.syncPages(sFile, id.intValue(), this.getAddress());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class FinishPageMessageOperation
    implements TransactionOperation {
        private final PageTransactionInfo pageTransaction;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;
        private final Set<PagingStore> usedStores = new HashSet<PagingStore>();
        private boolean stored = false;

        public void addStore(PagingStore store) {
            this.usedStores.add(store);
        }

        public FinishPageMessageOperation(PageTransactionInfo pageTransaction, StorageManager storageManager, PagingManager pagingManager) {
            this.pageTransaction = pageTransaction;
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        @Override
        public void afterCommit(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void syncStore() throws Exception {
            for (PagingStore store : this.usedStores) {
                store.sync();
            }
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void storePageTX(Transaction tx) throws Exception {
            if (!this.stored) {
                tx.setContainsPersistent();
                this.pageTransaction.store(this.storageManager, this.pagingManager, tx);
                this.stored = true;
            }
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }

    private static final class OurRunnable
    implements Runnable {
        private boolean ran;
        private final Runnable runnable;

        private OurRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public synchronized void run() {
            if (!this.ran) {
                this.runnable.run();
                this.ran = true;
            }
        }
    }

    private class MemoryFreedRunnablesExecutor
    implements Runnable {
        private MemoryFreedRunnablesExecutor() {
        }

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = (Runnable)PagingStoreImpl.this.onMemoryFreedRunnables.poll()) != null) {
                runnable.run();
            }
        }
    }
}

