/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.net.URI;
import java.util.Map;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.xnio.IoUtils;

public final class EndpointSessionHandler
implements WebSocketConnectionCallback {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        ConfiguredServerEndpoint config = HandshakeUtil.getConfig(channel);
        try {
            InstanceFactory<Endpoint> endpointFactory = config.getEndpointFactory();
            Object instance = endpointFactory != null ? endpointFactory.createInstance() : new ImmediateInstanceHandle((Object)((Endpoint)config.getEndpointConfiguration().getConfigurator().getEndpointInstance(config.getEndpointConfiguration().getEndpointClass())));
            UndertowSession session = new UndertowSession(channel, URI.create(exchange.getRequestURI()), (Map)exchange.getAttachment(HandshakeUtil.PATH_PARAMS), exchange.getRequestParameters(), this, null, (InstanceHandle<Endpoint>)instance, (EndpointConfig)config.getEndpointConfiguration(), exchange.getQueryString(), config.getEncodingFactory().createEncoding((EndpointConfig)config.getEndpointConfiguration()), config.getOpenSessions());
            config.getOpenSessions().add(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            ((Endpoint)instance.getInstance()).onOpen((Session)session, (EndpointConfig)config.getEndpointConfiguration());
            channel.resumeReceives();
        }
        catch (InstantiationException e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            IoUtils.safeClose((Closeable)channel);
        }
    }
}

