/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.jsr.ServerWebSocketContainer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.Pool;
import org.xnio.XnioWorker;

public class WebSocketDeploymentInfo {
    public static final String ATTRIBUTE_NAME = "io.undertow.websockets.jsr.WebSocketDeploymentInfo";
    private XnioWorker worker;
    private Pool<ByteBuffer> buffers;
    private final List<Class<?>> annotatedEndpoints = new ArrayList();
    private final List<ServerEndpointConfig> programaticEndpoints = new ArrayList<ServerEndpointConfig>();
    private final List<ContainerReadyListener> containerReadyListeners = new ArrayList<ContainerReadyListener>();

    public XnioWorker getWorker() {
        return this.worker;
    }

    public WebSocketDeploymentInfo setWorker(XnioWorker worker) {
        this.worker = worker;
        return this;
    }

    public Pool<ByteBuffer> getBuffers() {
        return this.buffers;
    }

    public WebSocketDeploymentInfo setBuffers(Pool<ByteBuffer> buffers) {
        this.buffers = buffers;
        return this;
    }

    public WebSocketDeploymentInfo addEndpoint(Class<?> annotated) {
        this.annotatedEndpoints.add(annotated);
        return this;
    }

    public WebSocketDeploymentInfo addEndpoint(ServerEndpointConfig endpoint) {
        this.programaticEndpoints.add(endpoint);
        return this;
    }

    public List<Class<?>> getAnnotatedEndpoints() {
        return this.annotatedEndpoints;
    }

    public List<ServerEndpointConfig> getProgramaticEndpoints() {
        return this.programaticEndpoints;
    }

    void containerReady(ServerWebSocketContainer container) {
        for (ContainerReadyListener listener : this.containerReadyListeners) {
            listener.ready(container);
        }
    }

    public WebSocketDeploymentInfo addListener(ContainerReadyListener listener) {
        this.containerReadyListeners.add(listener);
        return this;
    }

    public static interface ContainerReadyListener {
        public void ready(ServerWebSocketContainer var1);
    }
}

