/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.operations.coordination.ServerRequireRestartTask;
import org.jboss.as.domain.controller.plan.RolloutPlanController;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DomainRolloutStepHandler
implements OperationStepHandler {
    private final DomainOperationContext domainOperationContext;
    private final Map<String, ProxyController> hostProxies;
    private final Map<String, ProxyController> serverProxies;
    private final ExecutorService executorService;
    private final ModelNode providedRolloutPlan;
    private final boolean trace = DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled();

    public DomainRolloutStepHandler(Map<String, ProxyController> hostProxies, Map<String, ProxyController> serverProxies, DomainOperationContext domainOperationContext, ModelNode rolloutPlan, ExecutorService executorService) {
        this.hostProxies = hostProxies;
        this.serverProxies = serverProxies;
        this.domainOperationContext = domainOperationContext;
        this.providedRolloutPlan = rolloutPlan;
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean pushToServers;
        if (context.hasFailureDescription()) {
            context.setRollbackOnly();
            context.stepCompleted();
            return;
        }
        context.attachIfAbsent(CompositeOperationHandler.DOMAIN_EXECUTION_KEY, (Object)Boolean.TRUE);
        boolean bl = pushToServers = !this.domainOperationContext.hasHostLevelFailures();
        if (pushToServers) {
            ModelNode ourResult = this.domainOperationContext.getCoordinatorResult();
            if (ourResult.has("failure-description")) {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator failed: %s", ourResult);
                }
                pushToServers = false;
                this.domainOperationContext.setCompleteRollback(true);
            } else {
                if (this.trace) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("coordinator succeeded: %s", ourResult);
                }
                for (ModelNode hostResult : this.domainOperationContext.getHostControllerResults().values()) {
                    if (!hostResult.has("failure-description")) continue;
                    if (this.trace) {
                        DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("host failed: %s", hostResult);
                    }
                    pushToServers = false;
                    this.domainOperationContext.setCompleteRollback(true);
                    break;
                }
            }
        }
        if (pushToServers) {
            this.domainOperationContext.setCompleteRollback(false);
            final HashMap<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks = new HashMap<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest>();
            final ArrayList<ServerTaskExecutor.ServerPreparedResponse> preparedResults = new ArrayList<ServerTaskExecutor.ServerPreparedResponse>();
            boolean completeStepCalled = false;
            try {
                this.pushToServers(context, submittedTasks, preparedResults);
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        DomainRolloutStepHandler.this.finalizeOp(submittedTasks, preparedResults);
                    }
                });
                completeStepCalled = true;
            }
            finally {
                if (!completeStepCalled) {
                    this.finalizeOp(submittedTasks, preparedResults);
                }
            }
        } else {
            this.reportHostFailures(context, operation);
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeOp(Map<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks, List<ServerTaskExecutor.ServerPreparedResponse> preparedResults) {
        boolean completeRollback = this.domainOperationContext.isCompleteRollback();
        String localHostName = this.domainOperationContext.getLocalHostInfo().getLocalHostName();
        for (ServerTaskExecutor.ServerPreparedResponse preparedResult : preparedResults) {
            boolean rollback;
            if (preparedResult.finalizeTransaction(!(rollback = completeRollback || this.domainOperationContext.isServerGroupRollback(preparedResult.getServerGroupName())))) continue;
            ServerIdentity identity = preparedResult.getServerIdentity();
            try {
                ModelNode result = preparedResult.getPreparedOperation().getPreparedResult();
                ProxyController proxy = this.hostProxies.get(identity.getHostName());
                if (proxy == null && localHostName.equals(identity.getHostName()) && (proxy = this.serverProxies.get(identity.getServerName())) == null) {
                    if (!this.trace) continue;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("No proxy for %s", identity);
                    continue;
                }
                Future<ModelNode> future = this.executorService.submit(new ServerRequireRestartTask(identity, proxy, result));
                submittedTasks.put(identity, new ServerTaskExecutor.ExecutedServerRequest(identity, future));
            }
            catch (Exception ignore) {}
        }
        boolean interrupted = false;
        try {
            for (Map.Entry<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> entry : submittedTasks.entrySet()) {
                ServerTaskExecutor.ExecutedServerRequest request = entry.getValue();
                Future<ModelNode> future = request.getFinalResult();
                try {
                    ModelNode finalResult = future.isCancelled() ? this.getCancelledResult() : future.get();
                    ModelNode transformedResult = request.transformResult(finalResult);
                    this.domainOperationContext.addServerResult(entry.getKey(), transformedResult);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.interruptedAwaitingFinalResponse(entry.getKey().getServerName(), entry.getKey().getHostName());
                }
                catch (ExecutionException e) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.caughtExceptionAwaitingFinalResponse(e.getCause(), entry.getKey().getServerName(), entry.getKey().getHostName());
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ModelNode getCancelledResult() {
        ModelNode cancelled = new ModelNode();
        cancelled.get("outcome").set("cancelled");
        return cancelled;
    }

    private void pushToServers(final OperationContext context, Map<ServerIdentity, ServerTaskExecutor.ExecutedServerRequest> submittedTasks, List<ServerTaskExecutor.ServerPreparedResponse> preparedResults) throws OperationFailedException {
        Map<String, Map<ServerIdentity, ModelNode>> opsByGroup;
        final String localHostName = this.domainOperationContext.getLocalHostInfo().getLocalHostName();
        HashMap<String, ModelNode> hostResults = new HashMap<String, ModelNode>(this.domainOperationContext.getHostControllerResults());
        if (this.domainOperationContext.getCoordinatorResult().isDefined()) {
            hostResults.put(localHostName, this.domainOperationContext.getCoordinatorResult());
        }
        if ((opsByGroup = this.getOpsByGroup(hostResults)).size() > 0) {
            ModelNode rolloutPlan = this.getRolloutPlan(this.providedRolloutPlan, opsByGroup);
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan is %s", rolloutPlan);
            }
            ServerTaskExecutor taskExecutor = new ServerTaskExecutor(context, submittedTasks, preparedResults){

                @Override
                protected boolean execute(TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation> listener, ServerIdentity server, ModelNode original) throws OperationFailedException {
                    String hostName = server.getHostName();
                    ProxyController proxy = (ProxyController)DomainRolloutStepHandler.this.hostProxies.get(hostName);
                    if (proxy == null) {
                        if (localHostName.equals(hostName)) {
                            proxy = (ProxyController)DomainRolloutStepHandler.this.serverProxies.get(server.getServerName());
                        }
                        if (proxy == null) {
                            if (DomainRolloutStepHandler.this.trace) {
                                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("No proxy for %s", server);
                            }
                            return false;
                        }
                    }
                    TransformingProxyController remoteProxyController = (TransformingProxyController)proxy;
                    OperationTransformer.TransformedOperation transformed = DomainRolloutStepHandler.this.domainOperationContext.transformServerOperation(hostName, remoteProxyController, context, original);
                    ModelNode transformedOperation = transformed.getTransformedOperation();
                    OperationResultTransformer resultTransformer = transformed.getResultTransformer();
                    TransactionalProtocolClient client = remoteProxyController.getProtocolClient();
                    return this.executeOperation(listener, client, server, transformedOperation, resultTransformer);
                }
            };
            RolloutPlanController rolloutPlanController = new RolloutPlanController(opsByGroup, rolloutPlan, this.domainOperationContext, taskExecutor, this.executorService);
            RolloutPlanController.Result planResult = rolloutPlanController.execute();
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Rollout plan result is %s", (Object)planResult);
            }
            if (planResult == RolloutPlanController.Result.FAILED || planResult == RolloutPlanController.Result.PARTIAL && this.domainOperationContext.isCompleteRollback()) {
                this.domainOperationContext.setCompleteRollback(true);
                context.getResult();
                context.getFailureDescription().set(DomainControllerMessages.MESSAGES.operationFailedOrRolledBack());
                this.domainOperationContext.setFailureReported(true);
            }
        }
    }

    private Map<String, Map<ServerIdentity, ModelNode>> getOpsByGroup(Map<String, ModelNode> hostResults) {
        HashMap<String, Map<ServerIdentity, ModelNode>> result = new HashMap<String, Map<ServerIdentity, ModelNode>>();
        for (Map.Entry<String, ModelNode> entry : hostResults.entrySet()) {
            ModelNode hostResult;
            if (this.trace) {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("1st phase result from host %s is %s", entry.getKey(), entry.getValue());
            }
            if (!(hostResult = entry.getValue().get("result")).hasDefined("server-operations")) continue;
            String host = entry.getKey();
            for (ModelNode item : hostResult.get("server-operations").asList()) {
                ModelNode op = this.translateDomainMappedOperation(item.require("operation"));
                for (Property prop : item.require("servers").asPropertyList()) {
                    String group = prop.getValue().asString();
                    HashMap<ServerIdentity, ModelNode> groupMap = (HashMap<ServerIdentity, ModelNode>)result.get(group);
                    if (groupMap == null) {
                        groupMap = new HashMap<ServerIdentity, ModelNode>();
                        result.put(group, groupMap);
                    }
                    groupMap.put(new ServerIdentity(host, group, prop.getName()), op);
                }
            }
        }
        return result;
    }

    private ModelNode translateDomainMappedOperation(ModelNode domainMappedOperation) {
        if (domainMappedOperation.hasDefined("operation")) {
            return domainMappedOperation;
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        ModelNode steps = composite.get("steps").setEmptyList();
        for (Property property : domainMappedOperation.asPropertyList()) {
            steps.add(this.translateDomainMappedOperation(property.getValue()));
        }
        return composite;
    }

    private ModelNode getRolloutPlan(ModelNode rolloutPlan, Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) throws OperationFailedException {
        if (rolloutPlan == null || !rolloutPlan.isDefined()) {
            rolloutPlan = this.getDefaultRolloutPlan(opsByGroup);
        } else {
            HashSet<String> found = new HashSet<String>();
            if (rolloutPlan.hasDefined("in-series")) {
                for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                    if (series.hasDefined("concurrent-groups")) {
                        for (Property prop : series.get("concurrent-groups").asPropertyList()) {
                            this.validateServerGroupPlan(found, prop);
                        }
                        continue;
                    }
                    if (series.hasDefined("server-group")) {
                        Property prop = series.get("server-group").asProperty();
                        this.validateServerGroupPlan(found, prop);
                        continue;
                    }
                    throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlan(series, "in-series")));
                }
            }
            HashSet<String> groups = new HashSet<String>(opsByGroup.keySet());
            groups.removeAll(found);
            if (!groups.isEmpty()) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlan(groups)));
            }
        }
        return rolloutPlan;
    }

    private void validateServerGroupPlan(Set<String> found, Property prop) throws OperationFailedException {
        int max;
        if (!found.add(prop.getName())) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanGroupAlreadyExists(prop.getName())));
        }
        ModelNode plan = prop.getValue();
        if (plan.hasDefined("max-failure-percentage")) {
            if (plan.has("max-failed-servers")) {
                plan.remove("max-failed-servers");
            }
            if ((max = plan.get("max-failure-percentage").asInt()) < 0 || max > 100) {
                throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanRange(prop.getName(), "max-failure-percentage", max)));
            }
        }
        if (plan.hasDefined("max-failed-servers") && (max = plan.get("max-failed-servers").asInt()) < 0) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.invalidRolloutPlanLess(prop.getName(), "max-failed-servers", max)));
        }
    }

    private ModelNode getDefaultRolloutPlan(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup) {
        ModelNode result = new ModelNode();
        if (opsByGroup.size() > 0) {
            ModelNode groups = result.get("in-series").add().get("concurrent-groups");
            ModelNode groupPlan = new ModelNode();
            groupPlan.get("rolling-to-servers").set(false);
            groupPlan.get("max-failed-servers").set(0);
            for (String group : opsByGroup.keySet()) {
                groups.add(group, groupPlan);
            }
            result.get("rollback-across-groups").set(true);
        }
        return result;
    }

    private void reportHostFailures(OperationContext context, ModelNode operation) {
        boolean isDomain = this.isDomainOperation(operation);
        if (!this.collectDomainFailure(context, isDomain)) {
            this.collectHostFailures(context, isDomain);
        }
    }

    private boolean collectDomainFailure(OperationContext context, boolean isDomain) {
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        ModelNode domainFailure = null;
        if (isDomain && coordinator != null && coordinator.has("failure-description")) {
            ModelNode modelNode = domainFailure = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
        }
        if (domainFailure != null) {
            context.getFailureDescription().get("domain-failure-description").set(domainFailure);
            this.domainOperationContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean collectHostFailures(OperationContext context, boolean isDomain) {
        ModelNode hostFailureResults = null;
        for (Map.Entry<String, ModelNode> entry : this.domainOperationContext.getHostControllerResults().entrySet()) {
            ModelNode hostResult = entry.getValue();
            if (!hostResult.has("failure-description")) continue;
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = hostResult.hasDefined("failure-description") ? hostResult.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(entry.getKey(), desc);
        }
        ModelNode coordinator = this.domainOperationContext.getCoordinatorResult();
        if (!isDomain && coordinator != null && coordinator.has("failure-description")) {
            if (hostFailureResults == null) {
                hostFailureResults = new ModelNode();
            }
            ModelNode desc = coordinator.hasDefined("failure-description") ? coordinator.get("failure-description") : new ModelNode().set(DomainControllerMessages.MESSAGES.unexplainedFailure());
            hostFailureResults.add(this.domainOperationContext.getLocalHostInfo().getLocalHostName(), desc);
        }
        if (hostFailureResults != null) {
            context.getFailureDescription().get("host-failure-descriptions").set(hostFailureResults);
            this.domainOperationContext.setFailureReported(true);
            return true;
        }
        return false;
    }

    private boolean isDomainOperation(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.size() == 0 || !address.getElement(0).getKey().equals("host");
    }
}

