/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.transaction.tm.DummyBaseTransactionManager;
import org.infinispan.transaction.tm.DummyNoXaXid;
import org.infinispan.transaction.tm.DummyXid;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DummyTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(DummyTransaction.class);
    private static boolean trace = log.isTraceEnabled();
    private volatile int status = 5;
    protected final DummyBaseTransactionManager tm_;
    protected final Xid xid;
    protected Set<Synchronization> syncs;
    private final List<XAResource> enlistedResources = new ArrayList<XAResource>(2);
    private int prepareStatus;

    public DummyTransaction(DummyBaseTransactionManager tm) {
        this.tm_ = tm;
        this.status = 0;
        this.xid = tm.isUseXaXid() ? new DummyXid(tm.transactionManagerId) : new DummyNoXaXid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this.runPrepare();
            if (this.status == 1 || this.status == 9) {
                this.runRollback();
                throw new RollbackException("Exception rolled back, status is: " + this.status);
            }
            this.runCommitTx();
        }
        finally {
            DummyBaseTransactionManager.setTransaction(null);
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.status = 9;
            this.runRollback();
            this.status = 4;
            this.notifyAfterCompletion(4);
        }
        catch (Throwable t) {
            log.errorRollingBack(t);
            throw new IllegalStateException(t);
        }
        DummyBaseTransactionManager.setTransaction(null);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        this.enlistedResources.add(xaRes);
        try {
            xaRes.start(this.xid, 0);
        }
        catch (XAException e) {
            log.errorEnlistingResource(e);
            throw new SystemException(e.getMessage());
        }
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (sync == null) {
            throw new IllegalArgumentException("null synchronization " + this);
        }
        if (this.syncs == null) {
            this.syncs = new HashSet<Synchronization>(8);
        }
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("already prepared. " + this);
            }
            case 8: {
                throw new IllegalStateException("already started committing. " + this);
            }
            case 3: {
                throw new IllegalStateException("already committed. " + this);
            }
            case 1: {
                throw new RollbackException("already marked for rollback " + this);
            }
            case 9: {
                throw new RollbackException("already started rolling back. " + this);
            }
            case 4: {
                throw new RollbackException("already rolled back. " + this);
            }
            case 6: {
                throw new IllegalStateException("no transaction. " + this);
            }
            case 5: {
                throw new IllegalStateException("unknown state " + this);
            }
            default: {
                throw new IllegalStateException("illegal status: " + this.status + " tx=" + this);
            }
        }
        if (trace) {
            log.tracef("registering synchronization handler %s", sync);
        }
        this.syncs.add(sync);
    }

    public boolean notifyBeforeCompletion() {
        boolean retval = true;
        if (this.syncs == null) {
            return true;
        }
        for (Synchronization s : this.syncs) {
            if (trace) {
                log.tracef("processing beforeCompletion for %s", s);
            }
            try {
                s.beforeCompletion();
            }
            catch (Throwable t) {
                retval = false;
                this.status = 1;
                log.beforeCompletionFailed(s, t);
            }
        }
        return retval;
    }

    public boolean runPrepare() throws SystemException {
        boolean successfulInit = this.notifyBeforeCompletion();
        this.status = successfulInit ? 7 : 9;
        DummyTransaction transaction = this.tm_.getTransaction();
        Collection<XAResource> resources = transaction.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                int prepareStatus = res.prepare(this.xid);
                transaction.setPrepareStatus(prepareStatus);
            }
            catch (XAException e) {
                log.trace("The resource wants to rollback!", e);
                this.status = 9;
                return false;
            }
            catch (Throwable th) {
                log.unexpectedErrorFromResourceManager(th);
                throw new SystemException(th.getMessage());
            }
        }
        if (this.status == 1 || this.status == 9) {
            return false;
        }
        this.status = 2;
        return true;
    }

    private void setPrepareStatus(int prepareStatus) {
        this.prepareStatus = prepareStatus;
    }

    public void notifyAfterCompletion(int status) {
        if (this.syncs == null) {
            return;
        }
        for (Synchronization s : this.syncs) {
            if (trace) {
                log.tracef("processing afterCompletion for %s", s);
            }
            try {
                s.afterCompletion(status);
            }
            catch (Throwable t) {
                log.afterCompletionFailed(s, t);
            }
        }
        this.syncs.clear();
    }

    public Collection<XAResource> getEnlistedResources() {
        return this.enlistedResources;
    }

    public void runRollback() {
        DummyTransaction transaction = this.tm_.getTransaction();
        Collection<XAResource> resources = transaction.getEnlistedResources();
        for (XAResource res : resources) {
            try {
                res.rollback(this.xid);
            }
            catch (XAException e) {
                log.errorRollingBack(e);
            }
        }
    }

    public void runCommitTx() throws HeuristicMixedException {
        try {
            this.status = 8;
            DummyTransaction transaction = this.tm_.getTransaction();
            if (transaction.getPrepareStatus() == 3) {
                log.debug("This is a read-only tx");
            } else {
                Collection<XAResource> resources = transaction.getEnlistedResources();
                for (XAResource res : resources) {
                    try {
                        res.commit(this.xid, false);
                    }
                    catch (XAException e) {
                        log.errorCommittingTx(e);
                        throw new HeuristicMixedException(e.getMessage());
                    }
                }
            }
            this.status = 3;
        }
        catch (HeuristicMixedException e) {
            this.status = 5;
            throw e;
        }
        finally {
            this.notifyAfterCompletion(this.status);
            DummyBaseTransactionManager.setTransaction(null);
        }
    }

    public void setStatus(int stat) {
        this.status = stat;
    }

    public String toString() {
        return "DummyTransaction{xid=" + this.xid + ", status=" + this.status + '}';
    }

    public int getPrepareStatus() {
        return this.prepareStatus;
    }

    public XAResource firstEnlistedResource() {
        return this.getEnlistedResources().iterator().next();
    }

    public Xid getXid() {
        return this.xid;
    }

    public Collection<Synchronization> getEnlistedSynchronization() {
        return this.syncs;
    }

    public final int hashCode() {
        return this.xid.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }
}

