/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ActionBeanWrapperInterface;
import com.arjuna.ats.arjuna.tools.osb.mbean.LogRecordWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ParticipantStatus;
import com.arjuna.ats.arjuna.tools.osb.mbean.StateManagerWrapper;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionBean
extends OSEntryBean
implements ActionBeanMBean {
    private StateManagerWrapper sminfo;
    private Collection<LogRecordWrapper> participants = new ArrayList<LogRecordWrapper>();
    protected ActionBeanWrapperInterface ra;

    public ActionBean(UidWrapper w) {
        super(w);
        boolean isJTS = JMXServer.isJTS() && w.getType().endsWith("ArjunaTransactionImple");
        List<UidWrapper> recuids = null;
        if (isJTS) {
            try {
                Class<?> cl = Class.forName(JMXServer.AJT_WRAPPER_TYPE);
                Constructor<?> constructor = cl.getConstructor(ActionBean.class, UidWrapper.class);
                this.ra = (ActionBeanWrapperInterface)constructor.newInstance(this, w);
                this.ra.activate();
            }
            catch (Exception e) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("Error constructing " + JMXServer.AJT_WRAPPER_TYPE + ": " + e));
                }
                this.ra = this.createWrapper(w, true);
            }
            recuids = w.probe(JMXServer.AJT_RECORD_TYPE);
        } else {
            this.ra = this.createWrapper(w, true);
        }
        this.sminfo = new StateManagerWrapper(StoreManager.getRecoveryStore(), this.getUid(), this.getType());
        for (ParticipantStatus lt : ParticipantStatus.values()) {
            this.findParticipants(recuids, this.ra.getRecords(lt), lt);
        }
    }

    protected ActionBeanWrapperInterface createWrapper(UidWrapper w, boolean activate) {
        GenericAtomicActionWrapper action = new GenericAtomicActionWrapper(w.getClassName(), w);
        if (activate) {
            action.activate();
        }
        return action;
    }

    @Override
    public StringBuilder toString(String prefix, StringBuilder sb) {
        this.ra.toString(prefix, sb);
        prefix = prefix + '\t';
        sb.append('\n').append(prefix).append(this.sminfo.getCreationTime());
        sb.append('\n').append(prefix).append(this.sminfo.getAgeInSeconds());
        for (LogRecordWrapper p : this.participants) {
            p.toString(prefix, sb);
        }
        return sb;
    }

    @Override
    public Uid getUid(AbstractRecord rec) {
        return this.ra.getUid(rec);
    }

    @Override
    public String remove() {
        try {
            if (!StoreManager.getRecoveryStore().remove_committed(this.getUid(), this.getType())) {
                return "Attempt to remove transaction failed";
            }
            this.w.probe();
            return "Transaction successfully removed";
        }
        catch (ObjectStoreException e) {
            return "Unable to remove transaction: " + e.getMessage();
        }
    }

    private void findParticipants(List<UidWrapper> recuids, RecordList list2, ParticipantStatus listType) {
        if (list2 != null) {
            AbstractRecord rec = list2.peekFront();
            while (rec != null) {
                LogRecordWrapper lw;
                int i;
                int n = i = recuids == null ? -1 : recuids.indexOf(new UidWrapper(this.ra.getUid(rec)));
                if (i != -1) {
                    OSEntryBean p = recuids.get(i).getMBean();
                    if (p instanceof LogRecordWrapper) {
                        lw = (LogRecordWrapper)p;
                        lw.init(this, rec, listType);
                    } else {
                        if (tsLogger.logger.isTraceEnabled()) {
                            tsLogger.logger.trace((Object)"participant record is not a LogRecordWrapper");
                        }
                        lw = this.createParticipant(rec, listType, recuids.get(i));
                    }
                } else {
                    lw = this.createParticipant(rec, listType);
                }
                lw.activate();
                this.participants.add(lw);
                rec = list2.peekNext(rec);
            }
        }
    }

    protected LogRecordWrapper createParticipant(AbstractRecord rec, ParticipantStatus listType) {
        return new LogRecordWrapper(this, rec, listType);
    }

    protected LogRecordWrapper createParticipant(AbstractRecord rec, ParticipantStatus listType, UidWrapper wrapper) {
        return new LogRecordWrapper(this, rec, listType, wrapper);
    }

    public LogRecordWrapper getParticipant(AbstractRecord rec) {
        for (LogRecordWrapper w : this.participants) {
            if (!w.getRecord().equals(rec)) continue;
            return w;
        }
        return null;
    }

    @Override
    public void register() {
        super.register();
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().registerMBean(p.getName(), p);
        }
    }

    @Override
    public void unregister() {
        for (LogRecordWrapper p : this.participants) {
            JMXServer.getAgent().unregisterMBean(p.getName());
        }
        super.unregister();
    }

    @Override
    public long getAgeInSeconds() {
        return this.sminfo.getAgeInSeconds();
    }

    @Override
    public String getCreationTime() {
        return this.sminfo.getCreationTime();
    }

    @Override
    public boolean isParticipant() {
        return false;
    }

    public boolean setStatus(LogRecordWrapper logrec, ParticipantStatus newStatus) {
        ParticipantStatus lt = logrec.getListType();
        AbstractRecord targRecord = logrec.getRecord();
        RecordList oldList = this.ra.getRecords(lt);
        RecordList newList = this.ra.getRecords(newStatus);
        if (oldList.remove(targRecord) && newList.insert(targRecord)) {
            if (lt.equals((Object)ParticipantStatus.HEURISTIC)) {
                switch (newStatus) {
                    case FAILED: {
                        this.ra.clearHeuristicDecision(8);
                        break;
                    }
                    case PENDING: {
                        this.ra.clearHeuristicDecision(9);
                        break;
                    }
                    case PREPARED: {
                        this.ra.clearHeuristicDecision(0);
                        break;
                    }
                    case READONLY: {
                        this.ra.clearHeuristicDecision(2);
                        break;
                    }
                }
            }
            this.ra.doUpdateState();
            return true;
        }
        return false;
    }

    public Collection<LogRecordWrapper> getParticipants() {
        return Collections.unmodifiableCollection(this.participants);
    }

    public class GenericAtomicActionWrapper
    implements ActionBeanWrapperInterface {
        boolean activated;
        BasicAction action;
        Map<String, RecordList> recs;
        Method setHeuristicDecision;
        Method updateState;
        UidWrapper uidWrapper;

        public GenericAtomicActionWrapper(String classType, UidWrapper w) {
            block5: {
                this.updateState = null;
                this.uidWrapper = w;
                this.recs = new HashMap<String, RecordList>();
                if (classType == null) {
                    classType = "com.arjuna.ats.arjuna.AtomicAction";
                }
                try {
                    Class<?> cls = Class.forName(classType);
                    Class[] pTypes = new Class[]{Uid.class};
                    Constructor<?> ctor = cls.getConstructor(pTypes);
                    Object[] args = new Object[]{w.getUid()};
                    this.action = (BasicAction)ctor.newInstance(args);
                    this.setHeuristicDecision = this.getMethod(this.action.getClass(), "setHeuristicDecision", Integer.TYPE);
                    this.updateState = this.getMethod(this.action.getClass(), "updateState", new Class[0]);
                    if (this.setHeuristicDecision != null) {
                        this.setHeuristicDecision.setAccessible(true);
                    }
                    if (this.updateState != null) {
                        this.updateState.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    this.action = null;
                    if (!tsLogger.logger.isDebugEnabled()) break block5;
                    tsLogger.logger.debug((Object)("unable to create log wrapper for type " + w.getType() + ": error: " + e.getMessage()));
                }
            }
        }

        @Override
        public BasicAction getAction() {
            return this.action;
        }

        @Override
        public boolean activate() {
            if (!this.activated && this.action != null) {
                this.activated = this.action.activate();
            }
            return this.activated;
        }

        @Override
        public void doUpdateState() {
            block5: {
                if (this.updateState != null && this.action != null) {
                    try {
                        this.updateState.invoke((Object)this.action, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        if (tsLogger.logger.isDebugEnabled()) {
                            tsLogger.logger.debug((Object)("failed to update heuristic for " + this.action.toString() + ": error: " + e.getMessage()));
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (!tsLogger.logger.isDebugEnabled()) break block5;
                        tsLogger.logger.debug((Object)("failed to update heuristic for " + this.action.toString() + ": error: " + e.getMessage()));
                    }
                }
            }
        }

        @Override
        public Uid get_uid() {
            return this.action != null ? this.action.get_uid() : this.uidWrapper.getUid();
        }

        @Override
        public Uid getUid(AbstractRecord rec) {
            return rec.order();
        }

        @Override
        public StringBuilder toString(String prefix, StringBuilder sb) {
            prefix = prefix + '\t';
            return sb.append('\n').append(prefix).append(this.get_uid());
        }

        @Override
        public void clearHeuristicDecision(int newDecision) {
            block5: {
                RecordList rl = this.getRecords("heuristicList");
                if (this.setHeuristicDecision != null && rl != null && rl.size() == 0) {
                    try {
                        this.setHeuristicDecision.invoke((Object)this.action, newDecision);
                    }
                    catch (IllegalAccessException e) {
                        if (tsLogger.logger.isDebugEnabled()) {
                            tsLogger.logger.debug((Object)("failed to update heuristic for " + this.action.toString() + ": error: " + e.getMessage()));
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (!tsLogger.logger.isDebugEnabled()) break block5;
                        tsLogger.logger.debug((Object)("failed to update heuristic for " + this.action.toString() + ": error: " + e.getMessage()));
                    }
                }
            }
        }

        private Field getField(Class cl, String fn) {
            try {
                return cl.getDeclaredField(fn);
            }
            catch (NoSuchFieldException e) {
                return this.getField(cl.getSuperclass(), fn);
            }
        }

        private Method getMethod(Class cl, String mn, Class<?> ... parameterTypes) {
            try {
                if (cl == null) {
                    return null;
                }
                return cl.getDeclaredMethod(mn, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return this.getMethod(cl.getSuperclass(), mn, parameterTypes);
            }
        }

        public RecordList getRecords(String ln) {
            if (this.action == null) {
                return null;
            }
            if (this.recs.containsKey(ln)) {
                return this.recs.get(ln);
            }
            Field f = this.getField(this.action.getClass(), ln);
            f.setAccessible(true);
            try {
                RecordList rl = (RecordList)f.get(this.action);
                if (rl != null) {
                    this.recs.put(ln, rl);
                }
                return rl;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public RecordList getRecords(ParticipantStatus type) {
            switch (type) {
                default: {
                    return this.getRecords("preparedList");
                }
                case FAILED: {
                    return this.getRecords("failedList");
                }
                case HEURISTIC: {
                    return this.getRecords("heuristicList");
                }
                case PENDING: {
                    return this.getRecords("pendingList");
                }
                case READONLY: 
            }
            return this.getRecords("readonlyList");
        }
    }
}

