/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.parsing.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class AttributeMarshallerFactory {
    public static AttributeMarshaller createSimpleListAttributeMarshaller() {
        return new AttributeMarshaller(){

            public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                this.marshallAsAttribute(attribute, resourceModel, marshallDefault, writer);
            }

            public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                ModelNode aliases = resourceModel.get(attribute.getName());
                if (aliases.isDefined()) {
                    StringBuilder builder = new StringBuilder();
                    for (ModelNode alias : aliases.asList()) {
                        if (builder.length() > 0) {
                            builder.append(' ');
                        }
                        builder.append(alias.asString());
                    }
                    writer.writeAttribute(attribute.getXmlName(), builder.toString());
                }
            }
        };
    }

    public static AttributeMarshaller createPropertyListAttributeMarshaller() {
        return new AttributeMarshaller(){

            public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                ModelNode properties = resourceModel.get(attribute.getName());
                if (properties.isDefined()) {
                    for (Property property : properties.asPropertyList()) {
                        writer.writeStartElement(Element.PROPERTY.getLocalName());
                        writer.writeAttribute(Element.NAME.getLocalName(), property.getName());
                        writer.writeCharacters(property.getValue().asString());
                        writer.writeEndElement();
                    }
                }
            }
        };
    }

    private AttributeMarshallerFactory() {
    }
}

