/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.wst.SystemException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import org.jboss.jbossts.txbridge.inbound.JaxWSTxInboundBridgeHandler;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class OptionalJaxWSTxInboundBridgeHandler
implements Handler {
    private JaxWSTxInboundBridgeHandler delegate;

    public boolean handleMessage(MessageContext messageContext) {
        Boolean isOutbound;
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleMessage()");
        }
        if ((isOutbound = (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound")) == null) {
            return true;
        }
        if (isOutbound.booleanValue()) {
            return this.handleOutbound(messageContext);
        }
        return this.handleInbound(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleFault()");
        }
        if (this.delegate != null) {
            return this.delegate.handleFault(messageContext);
        }
        return true;
    }

    public void close(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.close()");
        }
        if (this.delegate != null) {
            this.delegate.close(messageContext);
        }
    }

    private boolean handleInbound(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleInbound()");
        }
        if (this.isTransactionAvailable()) {
            this.delegate = new JaxWSTxInboundBridgeHandler();
            return this.delegate.handleInbound(messageContext);
        }
        this.delegate = null;
        return true;
    }

    private boolean handleOutbound(MessageContext messageContext) {
        if (txbridgeLogger.logger.isTraceEnabled()) {
            txbridgeLogger.logger.trace((Object)"OptionalJaxWSTxInboundBridgeHandler.handleOutbound()");
        }
        if (this.delegate != null) {
            return this.delegate.handleOutbound(messageContext);
        }
        return true;
    }

    private boolean isTransactionAvailable() {
        TxContext txContext = null;
        try {
            txContext = TransactionManagerFactory.transactionManager().currentTransaction();
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return txContext != null;
    }
}

