/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.wildfly.extension.batch.Attribute;
import org.wildfly.extension.batch.BatchSubsystemDefinition;
import org.wildfly.extension.batch.Element;
import org.wildfly.extension.batch.JobRepositoryDefinition;
import org.wildfly.extension.batch.Namespace;
import org.wildfly.jberet.BatchConfiguration;

class BatchSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final BatchSubsystemParser INSTANCE = new BatchSubsystemParser();
    private final ThreadsParser threadsParser = ThreadsParser.getInstance();

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{BatchSubsystemDefinition.SUBSYSTEM_PATH});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)subsystemAddress);
        list.add(subsystemAddOp);
        ModelNode jdbcAddOp = Util.createAddOperation((PathAddress)subsystemAddress.append(new PathElement[]{JobRepositoryDefinition.JDBC.getPathElement()}));
        list.add(jdbcAddOp);
        EnumSet<Element> requiredElements = EnumSet.of(Element.JOB_REPOSITORY, Element.THREAD_POOL);
        while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
            if (namespace == Namespace.BATCH_1_0) {
                String localName = reader.getLocalName();
                Element element = Element.forName(localName);
                if (element == Element.JOB_REPOSITORY) {
                    requiredElements.remove((Object)Element.JOB_REPOSITORY);
                    this.parseJobRepository(reader, subsystemAddOp, jdbcAddOp);
                    continue;
                }
                if (element == Element.THREAD_POOL) {
                    requiredElements.remove((Object)Element.THREAD_POOL);
                    this.threadsParser.parseUnboundedQueueThreadPool(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), list, "thread-pool", "batch");
                    continue;
                }
                if (element == Element.THREAD_FACTORY) {
                    this.threadsParser.parseThreadFactory(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), list, "thread-factory", null);
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElements.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElements);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJobRepository(XMLExtendedStreamReader reader, ModelNode subsystemAddOp, ModelNode jdbcAddOp) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            BatchConfiguration.JobRepositoryType jobRepositoryType;
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                jobRepositoryType = BatchConfiguration.JobRepositoryType.IN_MEMORY;
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            } else if (element == Element.JDBC) {
                jobRepositoryType = BatchConfiguration.JobRepositoryType.JDBC;
                if (reader.getAttributeCount() > 0) {
                    String value = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.JNDI_NAME.getLocalName());
                    JobRepositoryDefinition.JNDI_NAME.parseAndSetParameter(value, jdbcAddOp, (XMLStreamReader)reader);
                } else {
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            } else {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            BatchSubsystemDefinition.JOB_REPOSITORY_TYPE.parseAndSetParameter(jobRepositoryType.toString(), subsystemAddOp, (XMLStreamReader)reader);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        BatchSubsystemDefinition.JOB_REPOSITORY_TYPE.marshallAsElement(model, (XMLStreamWriter)writer);
        if (model.hasDefined("thread-pool")) {
            List threadPools = model.get("thread-pool").asPropertyList();
            for (Property threadPool : threadPools) {
                this.threadsParser.writeUnboundedQueueThreadPool(writer, threadPool, Element.THREAD_POOL.getLocalName(), false);
            }
        }
        if (model.hasDefined("thread-factory")) {
            List threadFactories = model.get("thread-factory").asPropertyList();
            for (Property threadFactory : threadFactories) {
                this.threadsParser.writeThreadFactory(writer, threadFactory);
            }
        }
        writer.writeEndElement();
    }
}

