/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;

public class ComponentRegistryUtils {
    private ComponentRegistryUtils() {
    }

    public static <T> T getComponent(Cache<?, ?> cache, Class<T> class1) {
        return ComponentRegistryUtils.getComponent(cache, class1, class1.getName());
    }

    public static <T> T getComponent(Cache<?, ?> cache, Class<T> class1, String name) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        Object component = componentRegistry.getComponent(class1, name);
        if (component == null) {
            throw new IllegalArgumentException("Indexing was not enabled on this cache. " + class1 + " not found in registry");
        }
        return (T)component;
    }

    public static QueryInterceptor getQueryInterceptor(Cache<?, ?> cache) {
        Class queryType = cache.getCacheConfiguration().indexing().indexLocalOnly() ? LocalQueryInterceptor.class : QueryInterceptor.class;
        return ComponentRegistryUtils.getComponent(cache, queryType);
    }
}

