/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.UndertowMessages;
import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeParser;
import io.undertow.attribute.ExchangeAttributes;
import io.undertow.predicate.AndPredicate;
import io.undertow.predicate.FalsePredicate;
import io.undertow.predicate.NotPredicate;
import io.undertow.predicate.OrPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.predicate.TruePredicate;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;

public class PredicateParser {
    public static final Predicate parse(String string, ClassLoader classLoader) {
        Map<String, PredicateBuilder> builders = PredicateParser.loadBuilders(classLoader);
        ExchangeAttributeParser attributeParser = ExchangeAttributes.parser(classLoader);
        return PredicateParser.parse(string, builders, attributeParser);
    }

    private static Map<String, PredicateBuilder> loadBuilders(ClassLoader classLoader) {
        ServiceLoader<PredicateBuilder> loader = ServiceLoader.load(PredicateBuilder.class, classLoader);
        HashMap<String, PredicateBuilder> ret = new HashMap<String, PredicateBuilder>();
        for (PredicateBuilder builder : loader) {
            if (ret.containsKey(builder.name())) {
                if (((PredicateBuilder)ret.get(builder.name())).getClass() == builder.getClass()) continue;
                throw UndertowMessages.MESSAGES.moreThanOnePredicateWithName(builder.name(), builder.getClass(), ((PredicateBuilder)ret.get(builder.name())).getClass());
            }
            ret.put(builder.name(), builder);
        }
        return ret;
    }

    private static IllegalStateException error(String string, int pos, String reason) {
        StringBuilder b = new StringBuilder();
        b.append(string);
        b.append('\n');
        for (int i = 0; i < pos; ++i) {
            b.append(' ');
        }
        b.append('^');
        throw UndertowMessages.MESSAGES.errorParsingPredicateString(reason, b.toString());
    }

    static Predicate parse(String string, Map<String, PredicateBuilder> builders, ExchangeAttributeParser attributeParser) {
        Deque<Token> tokens = PredicateParser.tokenize(string);
        ArrayDeque<String> operatorStack = new ArrayDeque<String>();
        ArrayDeque<Object> output = new ArrayDeque<Object>();
        block0: while (!tokens.isEmpty()) {
            Token token = tokens.poll();
            if (PredicateParser.isSpecialChar(token.token)) {
                if (token.token.equals("(")) {
                    operatorStack.push("(");
                    continue;
                }
                if (token.token.equals(")")) {
                    while (true) {
                        String op;
                        if ((op = (String)operatorStack.pop()) == null) {
                            throw PredicateParser.error(string, token.position, "Unexpected end of input");
                        }
                        if (op.equals("(")) continue block0;
                        output.push(op);
                    }
                }
                throw PredicateParser.error(string, token.position, "Mismatched parenthesis");
            }
            if (PredicateParser.isOperator(token.token)) {
                int exitingPrec;
                int prec = PredicateParser.precidence(token.token);
                String top = (String)operatorStack.peek();
                while (top != null && !top.equals("(") && prec <= (exitingPrec = PredicateParser.precidence(top))) {
                    output.push(operatorStack.pop());
                    top = (String)operatorStack.peek();
                }
                operatorStack.push(token.token);
                continue;
            }
            output.push(PredicateParser.parsePredicate(string, token, tokens, builders, attributeParser));
        }
        while (!operatorStack.isEmpty()) {
            String op = (String)operatorStack.pop();
            if (op.equals(")")) {
                throw PredicateParser.error(string, string.length(), "Mismatched parenthesis");
            }
            output.push(op);
        }
        Predicate predicate = PredicateParser.collapseOutput(output.pop(), output).resolve();
        if (!output.isEmpty()) {
            throw PredicateParser.error(string, 0, "Invalid expression");
        }
        return predicate;
    }

    private static Node collapseOutput(Object token, Deque<Object> tokens) {
        if (token instanceof Node) {
            return (Node)token;
        }
        if (token.equals("and")) {
            Node n1 = PredicateParser.collapseOutput(tokens.pop(), tokens);
            Node n2 = PredicateParser.collapseOutput(tokens.pop(), tokens);
            return new AndNode(n2, n1);
        }
        if (token.equals("or")) {
            Node n1 = PredicateParser.collapseOutput(tokens.pop(), tokens);
            Node n2 = PredicateParser.collapseOutput(tokens.pop(), tokens);
            return new OrNode(n2, n1);
        }
        if (token.equals("not")) {
            Node n1 = PredicateParser.collapseOutput(tokens.pop(), tokens);
            return new NotNode(n1);
        }
        throw new IllegalStateException("Invalid operator " + token);
    }

    private static Object parsePredicate(String string, Token token, Deque<Token> tokens, Map<String, PredicateBuilder> builders, ExchangeAttributeParser attributeParser) {
        if (token.token.equals("true")) {
            return new PredicateNode(TruePredicate.instance());
        }
        if (token.token.equals("false")) {
            return new PredicateNode(FalsePredicate.instance());
        }
        PredicateBuilder builder = builders.get(token.token);
        if (builder == null) {
            throw PredicateParser.error(string, token.position, "no predicate named " + token.token);
        }
        Token next = tokens.peek();
        if (next.token.equals("[")) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            tokens.poll();
            next = tokens.poll();
            if (next == null) {
                throw PredicateParser.error(string, string.length(), "Unexpected end of input");
            }
            if (next.token.equals("{")) {
                return PredicateParser.handleSingleArrayValue(string, builder, tokens, next, attributeParser);
            }
            while (!next.token.equals("]")) {
                Token equals = tokens.poll();
                if (!equals.token.equals("=")) {
                    if (equals.token.equals("]") && values.isEmpty()) {
                        return PredicateParser.handleSingleValue(string, builder, next, attributeParser);
                    }
                    if (equals.token.equals(",")) {
                        tokens.push(equals);
                        tokens.push(next);
                        return PredicateParser.handleSingleVarArgsValue(string, builder, tokens, next, attributeParser);
                    }
                    throw PredicateParser.error(string, equals.position, "Unexpected token");
                }
                Token value = tokens.poll();
                if (value == null) {
                    throw PredicateParser.error(string, string.length(), "Unexpected end of input");
                }
                if (value.token.equals("{")) {
                    values.put(next.token, PredicateParser.readArrayType(string, tokens, next, builder, attributeParser, "}"));
                } else {
                    if (PredicateParser.isOperator(value.token) || PredicateParser.isSpecialChar(value.token)) {
                        throw PredicateParser.error(string, value.position, "Unexpected token");
                    }
                    Class<?> type = builder.parameters().get(next.token);
                    if (type == null) {
                        throw PredicateParser.error(string, next.position, "Unexpected parameter " + next.token);
                    }
                    values.put(next.token, PredicateParser.coerceToType(string, value, type, attributeParser));
                }
                next = tokens.poll();
                if (next == null) {
                    throw PredicateParser.error(string, string.length(), "Unexpected end of input");
                }
                if (next.token.equals("]")) continue;
                if (!next.token.equals(",")) {
                    throw PredicateParser.error(string, string.length(), "Expecting , or ]");
                }
                next = tokens.poll();
                if (next != null) continue;
                throw PredicateParser.error(string, string.length(), "Unexpected end of input");
            }
            PredicateParser.checkParameters(string, next.position, values, builder);
            return new BuilderNode(builder, values);
        }
        if (PredicateParser.isSpecialChar(next.token)) {
            throw PredicateParser.error(string, next.position, "Unexpected character");
        }
        return new BuilderNode(builder);
    }

    private static Node handleSingleArrayValue(String string, PredicateBuilder builder, Deque<Token> tokens, Token token, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw PredicateParser.error(string, token.position, "default parameter not supported");
        }
        Object array = PredicateParser.readArrayType(string, tokens, new Token(sv, token.position), builder, attributeParser, "}");
        Token close = tokens.poll();
        if (!close.token.equals("]")) {
            throw PredicateParser.error(string, close.position, "expected ]");
        }
        return new BuilderNode(builder, Collections.singletonMap(sv, array));
    }

    private static Node handleSingleVarArgsValue(String string, PredicateBuilder builder, Deque<Token> tokens, Token token, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw PredicateParser.error(string, token.position, "default parameter not supported");
        }
        Object array = PredicateParser.readArrayType(string, tokens, new Token(sv, token.position), builder, attributeParser, "]");
        return new BuilderNode(builder, Collections.singletonMap(sv, array));
    }

    private static Object readArrayType(String string, Deque<Token> tokens, Token paramName, PredicateBuilder builder, ExchangeAttributeParser attributeParser, String expectedEndToken) {
        Class<?> type = builder.parameters().get(paramName.token);
        if (type == null) {
            throw PredicateParser.error(string, paramName.position, "no parameter called " + paramName.token);
        }
        if (!type.isArray()) {
            throw PredicateParser.error(string, paramName.position, "parameter is not an array type " + paramName.token);
        }
        Class<?> componentType = type.getComponentType();
        ArrayList<Object> values = new ArrayList<Object>();
        Token token = tokens.poll();
        while (token != null) {
            Token commaOrEnd = tokens.poll();
            values.add(PredicateParser.coerceToType(string, token, componentType, attributeParser));
            if (commaOrEnd.token.equals(expectedEndToken)) {
                Object array = Array.newInstance(componentType, values.size());
                for (int i = 0; i < values.size(); ++i) {
                    Array.set(array, i, values.get(i));
                }
                return array;
            }
            if (!commaOrEnd.token.equals(",")) {
                throw PredicateParser.error(string, commaOrEnd.position, "expected either , or }");
            }
            token = tokens.poll();
        }
        throw PredicateParser.error(string, string.length(), "unexpected end of input in array");
    }

    private static Object handleSingleValue(String string, PredicateBuilder builder, Token next, ExchangeAttributeParser attributeParser) {
        String sv = builder.defaultParameter();
        if (sv == null) {
            throw PredicateParser.error(string, next.position, "default parameter not supported");
        }
        Map<String, Object> values = Collections.singletonMap(sv, PredicateParser.coerceToType(string, next, builder.parameters().get(sv), attributeParser));
        PredicateParser.checkParameters(string, next.position, values, builder);
        return new BuilderNode(builder, values);
    }

    private static void checkParameters(String string, int pos, Map<String, Object> values, PredicateBuilder builder) {
        HashSet<String> required = new HashSet<String>(builder.requiredParameters());
        for (String key : values.keySet()) {
            required.remove(key);
        }
        if (!required.isEmpty()) {
            throw PredicateParser.error(string, pos, "Missing required parameters " + required);
        }
    }

    private static Object coerceToType(String string, Token token, Class<?> type, ExchangeAttributeParser attributeParser) {
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), 1);
            Array.set(array, 0, PredicateParser.coerceToType(string, token, type.getComponentType(), attributeParser));
            return array;
        }
        if (type == String.class) {
            return token.token;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(token.token);
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return Byte.valueOf(token.token);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            if (token.token.length() != 1) {
                throw PredicateParser.error(string, token.position, "Cannot cooerce " + token.token + " to a Character");
            }
            return Character.valueOf(token.token.charAt(0));
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return Short.valueOf(token.token);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.valueOf(token.token);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.valueOf(token.token);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(token.token);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.valueOf(token.token);
        }
        if (type.equals(ExchangeAttribute.class)) {
            return attributeParser.parse(token.token);
        }
        return token.token;
    }

    private static int precidence(String operator) {
        if (operator.equals("not")) {
            return 3;
        }
        if (operator.equals("and")) {
            return 2;
        }
        if (operator.equals("or")) {
            return 1;
        }
        throw new IllegalStateException();
    }

    private static boolean isOperator(String op) {
        return op.equals("and") || op.equals("or") || op.equals("not");
    }

    private static boolean isSpecialChar(String token) {
        if (token.length() != 1) {
            return false;
        }
        char c = token.charAt(0);
        switch (c) {
            case '(': 
            case ')': 
            case ',': 
            case '=': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    static Deque<Token> tokenize(String string) {
        char currentStringDelim = '\u0000';
        boolean inVariable = false;
        StringBuilder current = new StringBuilder();
        ArrayDeque<Token> ret = new ArrayDeque<Token>();
        block6: for (int pos = 0; pos < string.length(); ++pos) {
            char c = string.charAt(pos);
            if (currentStringDelim != '\u0000') {
                if (c == currentStringDelim && current.charAt(current.length() - 1) != '\\') {
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    currentStringDelim = '\u0000';
                    continue;
                }
                current.append(c);
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (current.length() == 0) continue block6;
                    ret.add(new Token(current.toString(), pos));
                    current.setLength(0);
                    continue block6;
                }
                case '(': 
                case ')': 
                case ',': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (inVariable) {
                        current.append(c);
                        if (c != '}') continue block6;
                        inVariable = false;
                        continue block6;
                    }
                    if (current.length() != 0) {
                        ret.add(new Token(current.toString(), pos));
                        current.setLength(0);
                    }
                    ret.add(new Token("" + c, pos));
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (current.length() != 0) {
                        throw PredicateParser.error(string, pos, "Unexpected token");
                    }
                    currentStringDelim = c;
                    continue block6;
                }
                case '%': {
                    current.append(c);
                    if (string.charAt(pos + 1) != '{') continue block6;
                    inVariable = true;
                    continue block6;
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (current.length() > 0) {
            ret.add(new Token(current.toString(), string.length()));
        }
        return ret;
    }

    private static class PredicateNode
    implements Node {
        private final Predicate predicate;

        private PredicateNode(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public Predicate resolve() {
            return this.predicate;
        }
    }

    private static class BuilderNode
    implements Node {
        private final PredicateBuilder builder;
        private final Map<String, Object> parameters;

        private BuilderNode(PredicateBuilder builder) {
            this.builder = builder;
            this.parameters = Collections.emptyMap();
        }

        private BuilderNode(PredicateBuilder builder, Map<String, Object> parameters) {
            this.builder = builder;
            this.parameters = parameters;
        }

        @Override
        public Predicate resolve() {
            return this.builder.build(this.parameters);
        }
    }

    private static class NotNode
    implements Node {
        private final Node node;

        private NotNode(Node node) {
            this.node = node;
        }

        @Override
        public Predicate resolve() {
            return new NotPredicate(this.node.resolve());
        }
    }

    private static class OrNode
    implements Node {
        private final Node node1;
        private final Node node2;

        private OrNode(Node node1, Node node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        @Override
        public Predicate resolve() {
            return new OrPredicate(this.node1.resolve(), this.node2.resolve());
        }
    }

    private static class AndNode
    implements Node {
        private final Node node1;
        private final Node node2;

        private AndNode(Node node1, Node node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        @Override
        public Predicate resolve() {
            return new AndPredicate(this.node1.resolve(), this.node2.resolve());
        }
    }

    private static interface Node {
        public Predicate resolve();
    }

    static final class Token {
        final String token;
        final int position;

        private Token(String token, int position) {
            this.token = token;
            this.position = position;
        }
    }
}

