/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AbstractAjpParser;
import io.undertow.server.protocol.ajp.AjpRequestParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.URLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;

public class AjpRequestParser
extends AbstractAjpParser {
    private final String encoding;
    private final boolean doDecode;
    private static final HttpString[] HTTP_HEADERS;
    public static final int FORWARD_REQUEST = 2;
    public static final int CPONG = 9;
    public static final int CPING = 10;
    public static final int SHUTDOWN = 7;
    private static final HttpString[] HTTP_METHODS;
    private static final String[] ATTRIBUTES;
    public static final String QUERY_STRING = "query_string";
    public static final String SSL_CERT = "ssl_cert";
    public static final String CONTEXT = "context";
    public static final String SERVLET_PATH = "servlet_path";
    public static final String REMOTE_USER = "remote_user";
    public static final String AUTH_TYPE = "auth_type";
    public static final String ROUTE = "route";
    public static final String SSL_CIPHER = "ssl_cipher";
    public static final String SSL_SESSION = "ssl_session";
    public static final String REQ_ATTRIBUTE = "req_attribute";
    public static final String SSL_KEY_SIZE = "ssl_key_size";
    public static final String SECRET = "secret";
    public static final String STORED_METHOD = "stored_method";

    public AjpRequestParser(String encoding, boolean doDecode) {
        this.encoding = encoding;
        this.doDecode = doDecode;
    }

    public void parse(ByteBuffer buf, AjpRequestParseState state, HttpServerExchange exchange) throws IOException {
        if (!buf.hasRemaining()) {
            return;
        }
        switch (state.state) {
            case 0: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    return;
                }
                if (result.value != 4660) {
                    throw new IllegalStateException("Wrong magic number");
                }
            }
            case 2: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 2;
                    return;
                }
                state.dataSize = result.value;
            }
            case 3: {
                byte prefix;
                if (!buf.hasRemaining()) {
                    state.state = 3;
                    return;
                }
                state.prefix = prefix = buf.get();
                if (prefix != 2) {
                    state.state = 15;
                    return;
                }
            }
            case 4: {
                if (!buf.hasRemaining()) {
                    state.state = 4;
                    return;
                }
                byte method = buf.get();
                if (method > 0 && method < 28) {
                    exchange.setRequestMethod(HTTP_METHODS[method]);
                } else {
                    throw new IllegalArgumentException("Unknown method type " + method);
                }
            }
            case 5: {
                Object result = this.parseString(buf, state, false);
                if (((AbstractAjpParser.StringHolder)result).readComplete) {
                    exchange.setProtocol(HttpString.tryFromString(((AbstractAjpParser.StringHolder)result).value));
                } else {
                    state.state = 5;
                    return;
                }
            }
            case 6: {
                Object result = this.parseString(buf, state, false);
                if (((AbstractAjpParser.StringHolder)result).readComplete) {
                    int colon = ((AbstractAjpParser.StringHolder)result).value.indexOf(59);
                    if (colon == -1) {
                        String res = this.decode(((AbstractAjpParser.StringHolder)result).value, ((AbstractAjpParser.StringHolder)result).containsUrlCharacters);
                        exchange.setRequestURI(((AbstractAjpParser.StringHolder)result).value);
                        exchange.setRequestPath(res);
                        exchange.setRelativePath(res);
                    } else {
                        String url = ((AbstractAjpParser.StringHolder)result).value.substring(0, colon);
                        String res = this.decode(url, ((AbstractAjpParser.StringHolder)result).containsUrlCharacters);
                        exchange.setRequestURI(url);
                        exchange.setRequestPath(res);
                        exchange.setRelativePath(res);
                        URLUtils.parsePathParms(((AbstractAjpParser.StringHolder)result).value.substring(colon + 1), exchange, this.encoding, this.doDecode && ((AbstractAjpParser.StringHolder)result).containsUrlCharacters);
                    }
                } else {
                    state.state = 6;
                    return;
                }
            }
            case 7: {
                Object result = this.parseString(buf, state, false);
                if (((AbstractAjpParser.StringHolder)result).readComplete) {
                    state.remoteAddress = ((AbstractAjpParser.StringHolder)result).value;
                } else {
                    state.state = 7;
                    return;
                }
            }
            case 8: {
                Object result = this.parseString(buf, state, false);
                if (!((AbstractAjpParser.StringHolder)result).readComplete) {
                    state.state = 8;
                    return;
                }
            }
            case 9: {
                Object result = this.parseString(buf, state, false);
                if (!((AbstractAjpParser.StringHolder)result).readComplete) {
                    state.state = 9;
                    return;
                }
            }
            case 10: {
                Object result = this.parse16BitInteger(buf, state);
                if (!((AbstractAjpParser.IntegerHolder)result).readComplete) {
                    state.state = 10;
                    return;
                }
            }
            case 11: {
                if (!buf.hasRemaining()) {
                    state.state = 11;
                    return;
                }
                byte isSsl = buf.get();
                if (isSsl != 0) {
                    exchange.setRequestScheme("https");
                } else {
                    exchange.setRequestScheme("http");
                }
            }
            case 12: {
                AbstractAjpParser.IntegerHolder result = this.parse16BitInteger(buf, state);
                if (!result.readComplete) {
                    state.state = 12;
                    return;
                }
                state.numHeaders = result.value;
            }
            case 13: {
                for (int readHeaders = exchange.getRequestHeaders().getHeaderNames().size(); readHeaders < state.numHeaders; ++readHeaders) {
                    if (state.currentHeader == null) {
                        AbstractAjpParser.StringHolder result = this.parseString(buf, state, true);
                        if (!result.readComplete) {
                            state.state = 13;
                            return;
                        }
                        state.currentHeader = result.header != null ? result.header : HttpString.tryFromString(result.value);
                    }
                    AbstractAjpParser.StringHolder result = this.parseString(buf, state, false);
                    if (!result.readComplete) {
                        state.state = 13;
                        return;
                    }
                    exchange.getRequestHeaders().add(state.currentHeader, result.value);
                    state.currentHeader = null;
                }
            }
            case 14: {
                while (true) {
                    String result;
                    Object resultHolder;
                    if (state.currentAttribute == null && state.currentIntegerPart == -1) {
                        if (!buf.hasRemaining()) {
                            state.state = 14;
                            return;
                        }
                        int val = 0xFF & buf.get();
                        if (val == 255) {
                            state.state = 15;
                            return;
                        }
                        if (val == 10) {
                            state.currentIntegerPart = 1;
                        } else {
                            state.currentAttribute = ATTRIBUTES[val];
                        }
                    }
                    if (state.currentIntegerPart == 1) {
                        AbstractAjpParser.StringHolder result2 = this.parseString(buf, state, false);
                        if (!result2.readComplete) {
                            state.state = 14;
                            return;
                        }
                        state.currentAttribute = result2.value;
                        state.currentIntegerPart = -1;
                    }
                    if (state.currentAttribute.equals(SSL_KEY_SIZE)) {
                        resultHolder = this.parse16BitInteger(buf, state);
                        if (!((AbstractAjpParser.IntegerHolder)resultHolder).readComplete) {
                            state.state = 14;
                            return;
                        }
                        result = Integer.toString(((AbstractAjpParser.IntegerHolder)resultHolder).value);
                    } else {
                        resultHolder = this.parseString(buf, state, false);
                        if (!((AbstractAjpParser.StringHolder)resultHolder).readComplete) {
                            state.state = 14;
                            return;
                        }
                        result = ((AbstractAjpParser.StringHolder)resultHolder).value;
                    }
                    if (state.currentAttribute.equals(QUERY_STRING)) {
                        exchange.setQueryString(result == null ? "" : result);
                        URLUtils.parseQueryString(result, exchange, this.encoding, this.doDecode);
                    } else {
                        state.attributes.put(state.currentAttribute, result);
                    }
                    state.currentAttribute = null;
                }
            }
        }
        state.state = 15;
    }

    private String decode(String url, boolean containsUrlCharacters) throws UnsupportedEncodingException {
        if (this.doDecode && containsUrlCharacters) {
            return URLDecoder.decode(url, this.encoding);
        }
        return url;
    }

    @Override
    protected HttpString headers(int offset) {
        return HTTP_HEADERS[offset];
    }

    static {
        HTTP_METHODS = new HttpString[28];
        AjpRequestParser.HTTP_METHODS[1] = Methods.OPTIONS;
        AjpRequestParser.HTTP_METHODS[2] = Methods.GET;
        AjpRequestParser.HTTP_METHODS[3] = Methods.HEAD;
        AjpRequestParser.HTTP_METHODS[4] = Methods.POST;
        AjpRequestParser.HTTP_METHODS[5] = Methods.PUT;
        AjpRequestParser.HTTP_METHODS[6] = Methods.DELETE;
        AjpRequestParser.HTTP_METHODS[7] = Methods.TRACE;
        AjpRequestParser.HTTP_METHODS[8] = Methods.PROPFIND;
        AjpRequestParser.HTTP_METHODS[9] = Methods.PROPPATCH;
        AjpRequestParser.HTTP_METHODS[10] = Methods.MKCOL;
        AjpRequestParser.HTTP_METHODS[11] = Methods.COPY;
        AjpRequestParser.HTTP_METHODS[12] = Methods.MOVE;
        AjpRequestParser.HTTP_METHODS[13] = Methods.LOCK;
        AjpRequestParser.HTTP_METHODS[14] = Methods.UNLOCK;
        AjpRequestParser.HTTP_METHODS[15] = Methods.ACL;
        AjpRequestParser.HTTP_METHODS[16] = Methods.REPORT;
        AjpRequestParser.HTTP_METHODS[17] = Methods.VERSION_CONTROL;
        AjpRequestParser.HTTP_METHODS[18] = Methods.CHECKIN;
        AjpRequestParser.HTTP_METHODS[19] = Methods.CHECKOUT;
        AjpRequestParser.HTTP_METHODS[20] = Methods.UNCHECKOUT;
        AjpRequestParser.HTTP_METHODS[21] = Methods.SEARCH;
        AjpRequestParser.HTTP_METHODS[22] = Methods.MKWORKSPACE;
        AjpRequestParser.HTTP_METHODS[23] = Methods.UPDATE;
        AjpRequestParser.HTTP_METHODS[24] = Methods.LABEL;
        AjpRequestParser.HTTP_METHODS[25] = Methods.MERGE;
        AjpRequestParser.HTTP_METHODS[26] = Methods.BASELINE_CONTROL;
        AjpRequestParser.HTTP_METHODS[27] = Methods.MKACTIVITY;
        HTTP_HEADERS = new HttpString[15];
        AjpRequestParser.HTTP_HEADERS[1] = Headers.ACCEPT;
        AjpRequestParser.HTTP_HEADERS[2] = Headers.ACCEPT_CHARSET;
        AjpRequestParser.HTTP_HEADERS[3] = Headers.ACCEPT_ENCODING;
        AjpRequestParser.HTTP_HEADERS[4] = Headers.ACCEPT_LANGUAGE;
        AjpRequestParser.HTTP_HEADERS[5] = Headers.AUTHORIZATION;
        AjpRequestParser.HTTP_HEADERS[6] = Headers.CONNECTION;
        AjpRequestParser.HTTP_HEADERS[7] = Headers.CONTENT_TYPE;
        AjpRequestParser.HTTP_HEADERS[8] = Headers.CONTENT_LENGTH;
        AjpRequestParser.HTTP_HEADERS[9] = Headers.COOKIE;
        AjpRequestParser.HTTP_HEADERS[10] = Headers.COOKIE2;
        AjpRequestParser.HTTP_HEADERS[11] = Headers.HOST;
        AjpRequestParser.HTTP_HEADERS[12] = Headers.PRAGMA;
        AjpRequestParser.HTTP_HEADERS[13] = Headers.REFERER;
        AjpRequestParser.HTTP_HEADERS[14] = Headers.USER_AGENT;
        ATTRIBUTES = new String[14];
        AjpRequestParser.ATTRIBUTES[1] = CONTEXT;
        AjpRequestParser.ATTRIBUTES[2] = SERVLET_PATH;
        AjpRequestParser.ATTRIBUTES[3] = REMOTE_USER;
        AjpRequestParser.ATTRIBUTES[4] = AUTH_TYPE;
        AjpRequestParser.ATTRIBUTES[5] = QUERY_STRING;
        AjpRequestParser.ATTRIBUTES[6] = ROUTE;
        AjpRequestParser.ATTRIBUTES[7] = SSL_CERT;
        AjpRequestParser.ATTRIBUTES[8] = SSL_CIPHER;
        AjpRequestParser.ATTRIBUTES[9] = SSL_SESSION;
        AjpRequestParser.ATTRIBUTES[10] = REQ_ATTRIBUTE;
        AjpRequestParser.ATTRIBUTES[11] = SSL_KEY_SIZE;
        AjpRequestParser.ATTRIBUTES[12] = SECRET;
        AjpRequestParser.ATTRIBUTES[13] = STORED_METHOD;
    }
}

