/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class PathMatcher<T> {
    private volatile T defaultHandler;
    private final ConcurrentMap<String, T> paths = new CopyOnWriteMap<String, T>();
    private final ConcurrentMap<String, T> exactPathMatches = new CopyOnWriteMap<String, T>();
    private volatile int[] lengths = new int[0];

    public PathMatcher(T defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public PathMatcher() {
    }

    public PathMatch<T> match(HttpServerExchange exchange) {
        Object match;
        String path = exchange.getRelativePath();
        if (!this.exactPathMatches.isEmpty() && (match = this.exactPathMatches.get(path)) != null) {
            return new PathMatch("", match);
        }
        int length = path.length();
        int[] lengths = this.lengths;
        for (int i = 0; i < lengths.length; ++i) {
            String part;
            Object next;
            char c;
            int pathLength = lengths[i];
            if (pathLength == length) {
                Object next2 = this.paths.get(path);
                if (next2 == null) continue;
                return new PathMatch(path.substring(pathLength), next2);
            }
            if (pathLength >= length || (c = path.charAt(pathLength)) != '/' || (next = this.paths.get(part = path.substring(0, pathLength))) == null) continue;
            return new PathMatch(path.substring(pathLength), next);
        }
        return new PathMatch<T>(exchange.getRelativePath(), this.defaultHandler);
    }

    public synchronized PathMatcher addPrefixPath(String path, T handler) {
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = handler;
            return this;
        }
        if (path.charAt(0) != '/') {
            this.paths.put("/" + path, handler);
        } else {
            this.paths.put(path, handler);
        }
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher addExactPath(String path, T handler) {
        if (path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.exactPathMatches.put("/" + path, handler);
        } else {
            this.exactPathMatches.put(path, handler);
        }
        return this;
    }

    private void buildLengths() {
        TreeSet<Integer> lengths = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (String p : this.paths.keySet()) {
            lengths.add(p.length());
        }
        int[] lengthArray = new int[lengths.size()];
        int pos = 0;
        Iterator i$ = lengths.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            lengthArray[pos++] = i;
        }
        this.lengths = lengthArray;
    }

    @Deprecated
    public synchronized PathMatcher removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathMatcher removePrefixPath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.equals("/")) {
            this.defaultHandler = null;
            return this;
        }
        if (path.charAt(0) != '/') {
            this.paths.remove("/" + path);
        } else {
            this.paths.remove(path);
        }
        this.buildLengths();
        return this;
    }

    public synchronized PathMatcher removeExactPath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.exactPathMatches.remove("/" + path);
        } else {
            this.exactPathMatches.remove(path);
        }
        return this;
    }

    public synchronized PathMatcher clearPaths() {
        this.paths.clear();
        this.exactPathMatches.clear();
        this.lengths = new int[0];
        this.defaultHandler = null;
        return this;
    }

    public Map<String, T> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }

    public static final class PathMatch<T> {
        private final String remaining;
        private final T value;

        public PathMatch(String remaining, T value) {
            this.remaining = remaining;
            this.value = value;
        }

        public String getRemaining() {
            return this.remaining;
        }

        public T getValue() {
            return this.value;
        }
    }
}

