/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.SingleTaskRunnable;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Lock modificationLock;
    private final LuceneBackendResources resources;
    private final List<LuceneWork> workList;
    private final IndexingMonitor monitor;

    LuceneBackendQueueTask(List<LuceneWork> workList, LuceneBackendResources resources, IndexingMonitor monitor) {
        this.workList = workList;
        this.resources = resources;
        this.monitor = monitor;
        this.modificationLock = resources.getParallelModificationLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.modificationLock.lock();
        try {
            this.applyUpdates();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(e);
            Thread.currentThread().interrupt();
            this.handleException(e);
        }
        catch (Exception e) {
            log.backendError(e);
            this.handleException(e);
        }
        finally {
            this.modificationLock.unlock();
        }
    }

    private void handleException(Exception e) {
        ErrorContextBuilder builder = new ErrorContextBuilder();
        builder.allWorkToBeDone(this.workList);
        builder.errorThatOccurred(e);
        this.resources.getErrorHandler().handle(builder.createErrorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates() throws InterruptedException, ExecutionException {
        AbstractWorkspaceImpl workspace = this.resources.getWorkspace();
        ErrorContextBuilder errorContextBuilder = new ErrorContextBuilder();
        errorContextBuilder.allWorkToBeDone(this.workList);
        IndexWriter indexWriter = workspace.getIndexWriter(errorContextBuilder);
        if (indexWriter == null) {
            log.cannotOpenIndexWriterCausePreviousError();
            return;
        }
        boolean taskExecutionSuccessful = true;
        try {
            taskExecutionSuccessful = this.workList.size() == 1 ? this.runSingleTask(this.workList.get(0), indexWriter, errorContextBuilder) : this.runMultipleTasks(indexWriter, errorContextBuilder);
            if (!taskExecutionSuccessful) {
                this.resources.getErrorHandler().handle(errorContextBuilder.createErrorContext());
            } else {
                workspace.optimizerPhase();
            }
            workspace.afterTransactionApplied(!taskExecutionSuccessful, false);
        }
        catch (Throwable throwable) {
            workspace.afterTransactionApplied(!taskExecutionSuccessful, false);
            throw throwable;
        }
    }

    private boolean runMultipleTasks(IndexWriter indexWriter, ErrorContextBuilder errorContextBuilder) throws InterruptedException {
        Object task;
        int queueSize = this.workList.size();
        ExecutorService executor = this.resources.getWorkersExecutor();
        Future[] submittedTasks = new Future[queueSize];
        for (int i = 0; i < queueSize; ++i) {
            LuceneWork luceneWork = this.workList.get(i);
            task = new SingleTaskRunnable(luceneWork, this.resources, indexWriter, this.monitor);
            submittedTasks[i] = executor.submit((Runnable)task, luceneWork);
        }
        boolean allTasksSuccessful = true;
        for (int i = 0; i < queueSize; ++i) {
            task = submittedTasks[i];
            try {
                LuceneWork work = (LuceneWork)task.get();
                errorContextBuilder.workCompleted(work);
                continue;
            }
            catch (ExecutionException e) {
                errorContextBuilder.addWorkThatFailed(this.workList.get(i));
                errorContextBuilder.errorThatOccurred(e.getCause());
                allTasksSuccessful = false;
            }
        }
        return allTasksSuccessful;
    }

    private boolean runSingleTask(LuceneWork luceneWork, IndexWriter indexWriter, ErrorContextBuilder errorContextBuilder) {
        try {
            SingleTaskRunnable.performWork(luceneWork, this.resources, indexWriter, this.monitor);
            return true;
        }
        catch (RuntimeException re) {
            errorContextBuilder.errorThatOccurred(re);
            errorContextBuilder.addWorkThatFailed(luceneWork);
            return false;
        }
    }
}

