/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.CalendarBridgeMapping;
import org.hibernate.search.cfg.DateBridgeMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FieldBridgeMapping;
import org.hibernate.search.cfg.NumericFieldMapping;
import org.hibernate.search.cfg.PropertyDescriptor;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;

public class FieldMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;
    private final PropertyDescriptor property;
    private final Map<String, Object> field = new HashMap<String, Object>();

    public FieldMapping(PropertyDescriptor property, EntityDescriptor entity, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = entity;
        this.property = property;
        property.addField(this.field);
    }

    public FieldMapping name(String fieldName) {
        this.field.put("name", fieldName);
        return this;
    }

    public FieldMapping store(Store store) {
        this.field.put("store", (Object)store);
        return this;
    }

    public FieldMapping index(Index index) {
        this.field.put("index", (Object)index);
        return this;
    }

    public FieldMapping analyze(Analyze analyze) {
        this.field.put("analyze", (Object)analyze);
        return this;
    }

    public FieldMapping norms(Norms norms) {
        this.field.put("norms", (Object)norms);
        return this;
    }

    public FieldMapping termVector(TermVector termVector) {
        this.field.put("termVector", (Object)termVector);
        return this;
    }

    public FieldMapping boost(float boost) {
        HashMap<String, Float> boostAnn = new HashMap<String, Float>();
        boostAnn.put("value", Float.valueOf(boost));
        this.field.put("boost", boostAnn);
        return this;
    }

    public FieldBridgeMapping bridge(Class<?> impl) {
        return new FieldBridgeMapping(impl, this.field, this, this.property, this.entity, this.mapping);
    }

    public FieldMapping analyzer(Class<?> analyzerClass) {
        HashMap analyzer = new HashMap();
        analyzer.put("impl", analyzerClass);
        this.field.put("analyzer", analyzer);
        return this;
    }

    public FieldMapping analyzer(String analyzerDef) {
        HashMap<String, String> analyzer = new HashMap<String, String>();
        analyzer.put("definition", analyzerDef);
        this.field.put("analyzer", analyzer);
        return this;
    }

    public FieldMapping indexNullAs(String indexNullAs) {
        this.field.put("indexNullAs", indexNullAs);
        return this;
    }

    public FieldMapping field() {
        return new FieldMapping(this.property, this.entity, this.mapping);
    }

    public NumericFieldMapping numericField() {
        return new NumericFieldMapping(this.property, this.entity, this.mapping);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public DateBridgeMapping dateBridge(Resolution resolution) {
        return new DateBridgeMapping(this.mapping, this.entity, this.property, resolution);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerFactory, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public CalendarBridgeMapping calendarBridge(Resolution resolution) {
        return new CalendarBridgeMapping(this.mapping, this.entity, this.property, resolution);
    }
}

