/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.exception.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.impl.ErrorContextImpl;

public class ErrorContextBuilder {
    private Throwable th;
    private List<LuceneWork> workToBeDone;
    private List<LuceneWork> failingOperations;
    private List<LuceneWork> operationsThatWorked;

    public ErrorContextBuilder errorThatOccurred(Throwable th) {
        this.th = th;
        return this;
    }

    public ErrorContextBuilder addWorkThatFailed(LuceneWork failedWork) {
        this.getFailingOperations().add(failedWork);
        return this;
    }

    public ErrorContextBuilder addAllWorkThatFailed(List<LuceneWork> worksThatFailed) {
        this.getFailingOperations().addAll(worksThatFailed);
        return this;
    }

    public ErrorContextBuilder workCompleted(LuceneWork luceneWork) {
        this.getOperationsThatWorked().add(luceneWork);
        return this;
    }

    public ErrorContextBuilder allWorkToBeDone(List<LuceneWork> workOnWriter) {
        this.workToBeDone = new ArrayList<LuceneWork>(workOnWriter);
        return this;
    }

    public ErrorContext createErrorContext() {
        ErrorContextImpl context = new ErrorContextImpl();
        context.setThrowable(this.th);
        if (this.workToBeDone != null) {
            ArrayList<LuceneWork> workLeft = new ArrayList<LuceneWork>(this.workToBeDone);
            if (this.operationsThatWorked != null) {
                workLeft.removeAll(this.operationsThatWorked);
            }
            if (!workLeft.isEmpty()) {
                context.setOperationAtFault((LuceneWork)workLeft.remove(0));
                this.getFailingOperations().addAll(workLeft);
            }
        }
        context.setFailingOperations(this.getFailingOperations());
        return context;
    }

    private List<LuceneWork> getFailingOperations() {
        if (this.failingOperations == null) {
            this.failingOperations = new ArrayList<LuceneWork>();
        }
        return this.failingOperations;
    }

    private List<LuceneWork> getOperationsThatWorked() {
        if (this.operationsThatWorked == null) {
            this.operationsThatWorked = new ArrayList<LuceneWork>();
        }
        return this.operationsThatWorked;
    }
}

