/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;

public final class ScopedAnalyzer
extends Analyzer {
    private Analyzer globalAnalyzer;
    private Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

    public ScopedAnalyzer() {
    }

    private ScopedAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        this.globalAnalyzer = globalAnalyzer;
        for (Map.Entry<String, Analyzer> entry : scopedAnalyzers.entrySet()) {
            this.addScopedAnalyzer(entry.getKey(), entry.getValue());
        }
    }

    public void setGlobalAnalyzer(Analyzer globalAnalyzer) {
        this.globalAnalyzer = globalAnalyzer;
    }

    public void addScopedAnalyzer(String scope, Analyzer scopedAnalyzer) {
        this.scopedAnalyzers.put(scope, scopedAnalyzer);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.getAnalyzer(fieldName).reusableTokenStream(fieldName, reader);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
    }

    public int getOffsetGap(Fieldable field) {
        return this.getAnalyzer(field.name()).getOffsetGap(field);
    }

    private Analyzer getAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            analyzer = this.globalAnalyzer;
        }
        return analyzer;
    }

    public ScopedAnalyzer clone() {
        ScopedAnalyzer clone = new ScopedAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
        return clone;
    }
}

