/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;

public class JmsActivationSpec
implements ActivationSpec {
    private static final Logger log = Logger.getLogger(JmsActivationSpec.class);
    private ResourceAdapter ra;
    private String destination;
    private String destinationType = Destination.class.getName();
    private String messageSelector;
    private int acknowledgeMode = 1;
    private boolean subscriptionDurability;
    private String clientId;
    private String subscriptionName;
    private long reconnectInterval = 10L;
    private String user;
    private String pass;
    private int maxMessages = 1;
    private int minSession = 1;
    private int maxSession = 15;
    private int reconnectAttempts = -1;
    private int transactionTimeout;
    private boolean forceClearOnShutdown = false;
    private long forceClearOnShutdownInterval = 1000L;
    private int forceClearAttempts = 0;
    private String jndiParameters;
    private String connectionFactory;

    public void setForceClearOnShutdown(boolean forceClear) {
        this.forceClearOnShutdown = forceClear;
    }

    public boolean isForceClearOnShutdown() {
        return this.forceClearOnShutdown;
    }

    public long getForceClearOnShutdownInterval() {
        return this.forceClearOnShutdownInterval;
    }

    public void setForceClearOnShutdownInterval(long forceClearOnShutdownInterval) {
        this.forceClearOnShutdownInterval = forceClearOnShutdownInterval;
    }

    public int getForceClearAttempts() {
        return this.forceClearAttempts;
    }

    public void setForceClearAttempts(int forceClearAttempts) {
        this.forceClearAttempts = forceClearAttempts;
    }

    public String getAcknowledgeMode() {
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        if (1 == this.acknowledgeMode) {
            return "Auto-acknowledge";
        }
        return "unknown";
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        if ("DUPS_OK_ACKNOWLEDGE".equals(acknowledgeMode) || "Dups-ok-acknowledge".equals(acknowledgeMode)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equals(acknowledgeMode) || "Auto-acknowledge".equals(acknowledgeMode)) {
            this.acknowledgeMode = 1;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode: " + acknowledgeMode);
        }
    }

    public int getAcknowledgeModeInt() {
        return this.acknowledgeMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        if (!(Topic.class.getName().equals(destinationType) || Queue.class.getName().equals(destinationType) || Destination.class.getName().equals(destinationType))) {
            throw new IllegalArgumentException("Unsupported destinationType: " + destinationType);
        }
        this.destinationType = destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public String getSubscriptionDurability() {
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        this.subscriptionDurability = "Durable".equals(subscriptionDurability);
    }

    public boolean isDurable() {
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public long getReconnectIntervalLong() {
        return this.reconnectInterval * 1000L;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMaxMessagesInt() {
        return this.maxMessages;
    }

    public int getMinSession() {
        return this.minSession;
    }

    public void setMinSession(int minSession) {
        this.minSession = minSession;
    }

    public int getMinSessionInt() {
        return this.minSession;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public int getMaxSessionInt() {
        return this.maxSession;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        this.ra = ra;
    }

    public void validate() throws InvalidPropertyException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("validate " + this));
        }
        if (this.destination == null || this.destination.trim().equals("")) {
            throw new InvalidPropertyException("destination is mandatory");
        }
        if (this.connectionFactory == null || this.connectionFactory.trim().equals("")) {
            throw new InvalidPropertyException("connectionFactory is mandatory");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JmsActivation.defaultToString(this)).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" messageSelector=").append(this.messageSelector);
        }
        buffer.append(" acknowledgeMode=").append(this.getAcknowledgeMode());
        buffer.append(" subscriptionDurability=").append(this.subscriptionDurability);
        if (this.clientId != null) {
            buffer.append(" clientID=").append(this.clientId);
        }
        if (this.subscriptionName != null) {
            buffer.append(" subscriptionName=").append(this.subscriptionName);
        }
        buffer.append(" reconnectInterval=").append(this.reconnectInterval);
        buffer.append(" reconnectAttempts=").append(this.reconnectAttempts);
        buffer.append(" user=").append(this.user);
        if (this.pass != null) {
            buffer.append(" password=").append("<not shown>");
        }
        buffer.append(" maxMessages=").append(this.maxMessages);
        buffer.append(" minSession=").append(this.minSession);
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(" connectionFactory=").append(this.connectionFactory);
        buffer.append(" jndiParameters=").append(this.jndiParameters);
        buffer.append(')');
        return buffer.toString();
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setJndiParameters(String jndiParameters) {
        this.jndiParameters = jndiParameters;
    }

    public String getJndiParameters() {
        return this.jndiParameters;
    }

    public void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }
}

