/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.net.InetAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.modcluster.container.Connector;
import org.wildfly.extension.undertow.AjpListenerService;
import org.wildfly.extension.undertow.HttpListenerService;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.mod_cluster.undertow.metric.BytesReceivedStreamSourceConduit;
import org.wildfly.mod_cluster.undertow.metric.BytesSentStreamSinkConduit;
import org.wildfly.mod_cluster.undertow.metric.RequestCountHttpHandler;
import org.wildfly.mod_cluster.undertow.metric.RunningRequestsThreadSetupAction;
import org.xnio.XnioWorker;

public class UndertowConnector
implements Connector {
    private final ListenerService<?> listener;

    public UndertowConnector(ListenerService<?> listener) {
        this.listener = listener;
    }

    public boolean isReverse() {
        return true;
    }

    public Connector.Type getType() {
        if (this.listener instanceof AjpListenerService) {
            return Connector.Type.AJP;
        }
        if (this.listener instanceof HttpListenerService) {
            if (this.listener.isSecure()) {
                return Connector.Type.HTTPS;
            }
            return Connector.Type.HTTP;
        }
        return null;
    }

    public InetAddress getAddress() {
        return ((SocketBinding)this.listener.getBinding().getValue()).getAddress();
    }

    public void setAddress(InetAddress address) {
    }

    public int getPort() {
        return ((SocketBinding)this.listener.getBinding().getValue()).getAbsolutePort();
    }

    public boolean isAvailable() {
        return !((XnioWorker)this.listener.getWorker().getValue()).isShutdown();
    }

    public int getMaxThreads() {
        return -1;
    }

    public int getBusyThreads() {
        return RunningRequestsThreadSetupAction.getRunningRequestCount();
    }

    public long getBytesSent() {
        return BytesSentStreamSinkConduit.getBytesSent();
    }

    public long getBytesReceived() {
        return BytesReceivedStreamSourceConduit.getBytesReceived();
    }

    public long getRequestCount() {
        return RequestCountHttpHandler.getRequestCount();
    }

    public String toString() {
        return this.listener.getName();
    }

    public boolean equals(Object object) {
        if (!(object instanceof UndertowConnector)) {
            return false;
        }
        UndertowConnector connector = (UndertowConnector)object;
        return this.listener.getName().equals(connector.listener.getName());
    }

    public int hashCode() {
        return this.listener.getName().hashCode();
    }
}

