/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.CommandLine;
import org.jboss.as.cli.gui.component.CLIOutput;
import org.jboss.dmr.ModelNode;

public class CliGuiContext {
    private CommandContext cmdCtx;
    private CommandExecutor executor;
    private JPanel mainPanel;
    private CommandLine cmdLine;
    private boolean isStandalone;
    private CLIOutput output;
    private JTabbedPane tabs;

    CliGuiContext() {
    }

    void setOutput(CLIOutput output) {
        this.output = output;
    }

    void setCommandContext(CommandContext cmdCtx) {
        this.cmdCtx = cmdCtx;
    }

    void setTabs(JTabbedPane tabs) {
        this.tabs = tabs;
    }

    void setExecutor(CommandExecutor executor) {
        this.executor = executor;
        try {
            ModelNode result = executor.doCommand("/:read-attribute(name=process-type)");
            this.isStandalone = result.get("result").asString().equals("Server");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    void setCommandLine(CommandLine cmdLine) {
        this.cmdLine = cmdLine;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public CLIOutput getOutput() {
        return this.output;
    }

    public CommandContext getCommmandContext() {
        return this.cmdCtx;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public Window getMainWindow() {
        return SwingUtilities.getWindowAncestor(this.mainPanel);
    }

    public CommandLine getCommandLine() {
        return this.cmdLine;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }
}

