/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.vfs.BasicMountHandle;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFSLogger;
import org.jboss.vfs.VFSMessages;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileAssembly;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.spi.AssemblyFileSystem;
import org.jboss.vfs.spi.FileSystem;
import org.jboss.vfs.spi.JavaZipFileSystem;
import org.jboss.vfs.spi.MountHandle;
import org.jboss.vfs.spi.RealFileSystem;
import org.jboss.vfs.spi.RootFileSystem;

public class VFS {
    private static final ConcurrentMap<VirtualFile, Map<String, Mount>> mounts = new ConcurrentHashMap<VirtualFile, Map<String, Mount>>();
    private static final VirtualFile rootVirtualFile = VFS.createDefaultRoot();
    private static final Mount rootMount = new Mount(RootFileSystem.ROOT_INSTANCE, rootVirtualFile);
    private static final Set EMPTY_REMOVABLE_SET;

    private static VirtualFile createDefaultRoot() {
        return VFS.isWindows() ? VFS.getChild("/") : new VirtualFile("/", null);
    }

    private VFS() {
    }

    private static void init() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || pkgs.trim().length() == 0) {
            pkgs = "org.jboss.net.protocol|org.jboss.vfs.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        } else if (!pkgs.contains("org.jboss.vfs.protocol")) {
            if (!pkgs.contains("org.jboss.net.protocol")) {
                pkgs = pkgs + "|org.jboss.net.protocol";
            }
            pkgs = pkgs + "|org.jboss.vfs.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        }
    }

    public static Closeable mount(VirtualFile mountPoint, FileSystem fileSystem) throws IOException {
        HashMap<String, Mount> newMap;
        Map<String, Mount> childMountMap;
        VirtualFile parent = mountPoint.getParent();
        if (parent == null) {
            throw VFSMessages.MESSAGES.rootFileSystemAlreadyMounted();
        }
        String name = mountPoint.getName();
        Mount mount = new Mount(fileSystem, mountPoint);
        ConcurrentMap<VirtualFile, Map<String, Mount>> mounts = VFS.mounts;
        do {
            if ((childMountMap = (Map<String, Mount>)mounts.get(parent)) == null && (childMountMap = mounts.putIfAbsent(parent, Collections.singletonMap(name, mount))) == null) {
                return mount;
            }
            newMap = new HashMap<String, Mount>(childMountMap);
            if (newMap.put(name, mount) == null) continue;
            throw VFSMessages.MESSAGES.fileSystemAlreadyMountedAtMountPoint(mountPoint);
        } while (!mounts.replace(parent, childMountMap, newMap));
        VFSLogger.ROOT_LOGGER.tracef("Mounted filesystem %s on mount point %s", (Object)fileSystem, (Object)mountPoint);
        return mount;
    }

    @Deprecated
    public static VirtualFile getChild(URL url) throws URISyntaxException {
        return VFS.getChild(url.toURI());
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static VirtualFile getChild(URI uri) {
        return VFS.getChild(uri.getPath());
    }

    public static VirtualFile getChild(String path) {
        if (path == null) {
            throw VFSMessages.MESSAGES.nullArgument("path");
        }
        VirtualFile root = null;
        if (VFS.isWindows()) {
            String absolute = new File(path).getAbsolutePath();
            if (absolute.length() > 2) {
                if (absolute.charAt(1) == ':') {
                    root = new VirtualFile("/" + absolute.charAt(0) + ":/", null);
                    path = absolute.substring(2).replace('\\', '/');
                } else if (absolute.charAt(0) == '\\' && absolute.charAt(1) == '\\') {
                    for (int i = 2; i < absolute.length(); ++i) {
                        if (absolute.charAt(i) != '\\') continue;
                        root = new VirtualFile("//" + absolute.substring(0, i) + "/", null);
                        path = absolute.substring(i).replace('\\', '/');
                        break;
                    }
                }
            }
            if (root == null) {
                throw VFSMessages.MESSAGES.invalidWin32Path(path);
            }
        } else {
            root = rootVirtualFile;
        }
        return root.getChild(path);
    }

    public static VirtualFile getRootVirtualFile() {
        return rootVirtualFile;
    }

    public static List<VirtualFile> getChildren() throws IOException {
        return VFS.getRootVirtualFile().getChildren(null);
    }

    public static List<VirtualFile> getChildren(VirtualFileFilter filter) throws IOException {
        return VFS.getRootVirtualFile().getChildren(filter);
    }

    public static List<VirtualFile> getChildrenRecursively() throws IOException {
        return VFS.getRootVirtualFile().getChildrenRecursively(null);
    }

    public static List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        return VFS.getRootVirtualFile().getChildrenRecursively(filter);
    }

    public static void visit(VirtualFileVisitor visitor) throws IOException {
        visitor.visit(VFS.getRootVirtualFile());
    }

    protected static void visit(VirtualFile file, VirtualFileVisitor visitor) throws IOException {
        if (file == null) {
            throw VFSMessages.MESSAGES.nullArgument("file");
        }
        visitor.visit(file);
    }

    static Mount getMount(VirtualFile virtualFile) {
        Mount mount;
        ConcurrentMap<VirtualFile, Map<String, Mount>> mounts = VFS.mounts;
        while (true) {
            VirtualFile parent;
            if ((parent = virtualFile.getParent()) == null) {
                return rootMount;
            }
            Map parentMounts = (Map)mounts.get(parent);
            if (parentMounts == null) {
                virtualFile = parent;
                continue;
            }
            mount = (Mount)parentMounts.get(virtualFile.getName());
            if (mount != null) break;
            virtualFile = parent;
        }
        return mount;
    }

    static Set<String> getSubmounts(VirtualFile virtualFile) {
        ConcurrentMap<VirtualFile, Map<String, Mount>> mounts = VFS.mounts;
        Map mountMap = (Map)mounts.get(virtualFile);
        if (mountMap == null) {
            return VFS.emptyRemovableSet();
        }
        return new HashSet<String>(mountMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MountHandle doMount(FileSystem fileSystem, VirtualFile mountPoint, Closeable ... additionalCloseables) throws IOException {
        boolean ok = false;
        try {
            Closeable mountHandle = VFS.mount(mountPoint, fileSystem);
            ok = true;
            BasicMountHandle basicMountHandle = new BasicMountHandle(fileSystem, mountHandle, additionalCloseables);
            return basicMountHandle;
        }
        finally {
            if (!ok) {
                VFSUtils.safeClose((Closeable)fileSystem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable mountZip(File zipFile, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        boolean ok = false;
        TempDir tempDir = tempFileProvider.createTempDir(zipFile.getName());
        try {
            MountHandle handle = VFS.doMount(new JavaZipFileSystem(zipFile, tempDir), mountPoint, new Closeable[0]);
            ok = true;
            MountHandle mountHandle = handle;
            return mountHandle;
        }
        finally {
            if (!ok) {
                VFSUtils.safeClose((Closeable)tempDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable mountZip(InputStream zipData, String zipName, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        boolean ok = false;
        try {
            MountHandle mountHandle;
            block7: {
                TempDir tempDir = tempFileProvider.createTempDir(zipName);
                try {
                    MountHandle handle = VFS.doMount(new JavaZipFileSystem(zipName, zipData, tempDir), mountPoint, new Closeable[0]);
                    ok = true;
                    mountHandle = handle;
                    if (ok) break block7;
                }
                catch (Throwable throwable) {
                    if (!ok) {
                        VFSUtils.safeClose((Closeable)tempDir);
                    }
                    throw throwable;
                }
                VFSUtils.safeClose((Closeable)tempDir);
            }
            return mountHandle;
        }
        finally {
            VFSUtils.safeClose((Closeable)zipData);
        }
    }

    public static Closeable mountZip(VirtualFile zipFile, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        return VFS.mountZip(zipFile.openStream(), zipFile.getName(), mountPoint, tempFileProvider);
    }

    public static Closeable mountReal(File realRoot, VirtualFile mountPoint) throws IOException {
        return VFS.doMount(new RealFileSystem(realRoot), mountPoint, new Closeable[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable mountTemp(VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        boolean ok = false;
        TempDir tempDir = tempFileProvider.createTempDir("tmpfs");
        try {
            MountHandle handle = VFS.doMount(new RealFileSystem(tempDir.getRoot()), mountPoint, tempDir);
            ok = true;
            MountHandle mountHandle = handle;
            return mountHandle;
        }
        finally {
            if (!ok) {
                VFSUtils.safeClose((Closeable)tempDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Closeable mountZipExpanded(File zipFile, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        boolean ok = false;
        TempDir tempDir = tempFileProvider.createTempDir(zipFile.getName());
        try {
            File rootFile = tempDir.getRoot();
            VFSUtils.unzip(zipFile, rootFile);
            MountHandle handle = VFS.doMount(new RealFileSystem(rootFile), mountPoint, tempDir);
            ok = true;
            MountHandle mountHandle = handle;
            return mountHandle;
        }
        finally {
            if (!ok) {
                VFSUtils.safeClose((Closeable)tempDir);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Closeable mountZipExpanded(InputStream zipData, String zipName, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Closeable mountZipExpanded(VirtualFile zipFile, VirtualFile mountPoint, TempFileProvider tempFileProvider) throws IOException {
        return VFS.mountZipExpanded(zipFile.openStream(), zipFile.getName(), mountPoint, tempFileProvider);
    }

    public static Closeable mountAssembly(VirtualFileAssembly assembly, VirtualFile mountPoint) throws IOException {
        return VFS.doMount(new AssemblyFileSystem(assembly), mountPoint, new Closeable[0]);
    }

    private static <E> Set<E> emptyRemovableSet() {
        return EMPTY_REMOVABLE_SET;
    }

    static {
        VFS.init();
        EMPTY_REMOVABLE_SET = new EmptyRemovableSet();
    }

    private static final class LeakDescriptor
    extends Throwable {
        private static final long serialVersionUID = 6034058126740270584L;

        private LeakDescriptor() {
        }

        @Override
        public String toString() {
            return "Allocation stack trace:";
        }
    }

    static final class Mount
    implements Closeable {
        private final FileSystem fileSystem;
        private final VirtualFile mountPoint;
        private final StackTraceElement[] allocationPoint;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        Mount(FileSystem fileSystem, VirtualFile mountPoint) {
            this.fileSystem = fileSystem;
            this.mountPoint = mountPoint;
            this.allocationPoint = Thread.currentThread().getStackTrace();
        }

        @Override
        public void close() throws IOException {
            if (this.closed.getAndSet(true)) {
                return;
            }
            String name = this.mountPoint.getName();
            VirtualFile parent = this.mountPoint.getParent();
            ConcurrentMap mounts = mounts;
            while (true) {
                Map newParentMounts;
                Map parentMounts;
                if ((parentMounts = (Map)mounts.get(parent)) == null) {
                    return;
                }
                Mount mount = (Mount)parentMounts.get(name);
                if (mount != this) {
                    return;
                }
                if (parentMounts.size() == 2) {
                    Iterator ei = parentMounts.entrySet().iterator();
                    Map.Entry e1 = ei.next();
                    if (((String)e1.getKey()).equals(name)) {
                        Map.Entry e2 = ei.next();
                        newParentMounts = Collections.singletonMap(e2.getKey(), e2.getValue());
                    } else {
                        newParentMounts = Collections.singletonMap(e1.getKey(), e1.getValue());
                    }
                    if (!mounts.replace(parent, parentMounts, newParentMounts)) continue;
                    VFSLogger.ROOT_LOGGER.tracef("Unmounted filesystem %s on mount point %s", (Object)this.fileSystem, (Object)this.mountPoint);
                    return;
                }
                if (parentMounts.size() == 1) {
                    if (!mounts.remove(parent, parentMounts)) continue;
                    VFSLogger.ROOT_LOGGER.tracef("Unmounted filesystem %s on mount point %s", (Object)this.fileSystem, (Object)this.mountPoint);
                    return;
                }
                newParentMounts = new HashMap(parentMounts);
                newParentMounts.remove(name);
                if (mounts.replace(parent, parentMounts, newParentMounts)) break;
            }
            VFSLogger.ROOT_LOGGER.tracef("Unmounted filesystem %s on mount point %s", (Object)this.fileSystem, (Object)this.mountPoint);
        }

        FileSystem getFileSystem() {
            return this.fileSystem;
        }

        VirtualFile getMountPoint() {
            return this.mountPoint;
        }

        protected void finalize() throws IOException {
            if (!this.closed.get()) {
                StackTraceElement[] allocationPoint = this.allocationPoint;
                if (allocationPoint != null) {
                    LeakDescriptor t = new LeakDescriptor();
                    t.setStackTrace(allocationPoint);
                    VFSLogger.ROOT_LOGGER.vfsMountLeaked(this.mountPoint, t);
                } else {
                    VFSLogger.ROOT_LOGGER.vfsMountLeaked(this.mountPoint, null);
                }
                this.close();
            }
        }
    }

    private static final class EmptyRemovableSet<E>
    extends AbstractSet<E> {
        private EmptyRemovableSet() {
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptySet().iterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

