/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class BridgeAdd
extends AbstractAddStepHandler {
    public static final BridgeAdd INSTANCE = new BridgeAdd();

    private BridgeAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        AlternativeAttributeCheckHandler.checkAlternatives(operation, BridgeDefinition.CONNECTOR_REFS.getName(), BridgeDefinition.DISCOVERY_GROUP_NAME.getName(), false);
        for (AttributeDefinition attributeDefinition : BridgeDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            if (hqService.getState() != ServiceController.State.UP) {
                throw MessagingMessages.MESSAGES.invalidServiceState(hqServiceName, ServiceController.State.UP, hqService.getState());
            }
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            BridgeConfiguration bridgeConfig = BridgeAdd.createBridgeConfiguration(context, name, model);
            HornetQServerControlImpl serverControl = ((HornetQServer)HornetQServer.class.cast(hqService.getValue())).getHornetQServerControl();
            BridgeAdd.createBridge(name, bridgeConfig, (HornetQServerControl)serverControl);
        }
    }

    static void addBridgeConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("bridge")) {
            List configs = configuration.getBridgeConfigurations();
            for (Property prop : model.get("bridge").asPropertyList()) {
                configs.add(BridgeAdd.createBridgeConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    static BridgeConfiguration createBridgeConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String queueName = BridgeDefinition.QUEUE_NAME.resolveModelAttribute(context, model).asString();
        ModelNode forwardingNode = BridgeDefinition.FORWARDING_ADDRESS.resolveModelAttribute(context, model);
        String forwardingAddress = forwardingNode.isDefined() ? forwardingNode.asString() : null;
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filterString = filterNode.isDefined() ? filterNode.asString() : null;
        ModelNode transformerNode = CommonAttributes.TRANSFORMER_CLASS_NAME.resolveModelAttribute(context, model);
        String transformerClassName = transformerNode.isDefined() ? transformerNode.asString() : null;
        int minLargeMessageSize = CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt();
        long retryInterval = CommonAttributes.RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        double retryIntervalMultiplier = CommonAttributes.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, model).asDouble();
        long maxRetryInterval = CommonAttributes.MAX_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong();
        int reconnectAttempts = BridgeDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(context, model).asInt();
        int reconnectAttemptsOnSameNode = BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE.resolveModelAttribute(context, model).asInt();
        boolean useDuplicateDetection = BridgeDefinition.USE_DUPLICATE_DETECTION.resolveModelAttribute(context, model).asBoolean();
        int confirmationWindowSize = CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, model).asInt();
        long clientFailureCheckPeriod = CommonAttributes.CHECK_PERIOD.resolveModelAttribute(context, model).asLong();
        long connectionTTL = CommonAttributes.CONNECTION_TTL.resolveModelAttribute(context, model).asLong();
        ModelNode discoveryNode = BridgeDefinition.DISCOVERY_GROUP_NAME.resolveModelAttribute(context, model);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? BridgeAdd.getStaticConnectors(model) : null;
        boolean ha = CommonAttributes.HA.resolveModelAttribute(context, model).asBoolean();
        String user = BridgeDefinition.USER.resolveModelAttribute(context, model).asString();
        String password = BridgeDefinition.PASSWORD.resolveModelAttribute(context, model).asString();
        if (discoveryGroupName != null) {
            return new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, reconnectAttempts, reconnectAttemptsOnSameNode, useDuplicateDetection, confirmationWindowSize, discoveryGroupName, ha, user, password);
        }
        return new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, reconnectAttempts, reconnectAttemptsOnSameNode, useDuplicateDetection, confirmationWindowSize, staticConnectors, ha, user, password);
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }

    static void createBridge(String name, BridgeConfiguration bridgeConfig, HornetQServerControl serverControl) {
        try {
            if (bridgeConfig.getDiscoveryGroupName() != null) {
                serverControl.createBridge(name, bridgeConfig.getQueueName(), bridgeConfig.getForwardingAddress(), bridgeConfig.getFilterString(), bridgeConfig.getTransformerClassName(), bridgeConfig.getRetryInterval(), bridgeConfig.getRetryIntervalMultiplier(), bridgeConfig.getReconnectAttempts(), bridgeConfig.isUseDuplicateDetection(), bridgeConfig.getConfirmationWindowSize(), bridgeConfig.getClientFailureCheckPeriod(), bridgeConfig.getDiscoveryGroupName(), true, bridgeConfig.isHA(), bridgeConfig.getUser(), bridgeConfig.getPassword());
            } else {
                boolean first = true;
                String connectors = "";
                for (String connector : bridgeConfig.getStaticConnectors()) {
                    if (!first) {
                        connectors = connectors + ",";
                    } else {
                        first = false;
                    }
                    connectors = connectors + connector;
                }
                serverControl.createBridge(name, bridgeConfig.getQueueName(), bridgeConfig.getForwardingAddress(), bridgeConfig.getFilterString(), bridgeConfig.getTransformerClassName(), bridgeConfig.getRetryInterval(), bridgeConfig.getRetryIntervalMultiplier(), bridgeConfig.getReconnectAttempts(), bridgeConfig.isUseDuplicateDetection(), bridgeConfig.getConfirmationWindowSize(), bridgeConfig.getClientFailureCheckPeriod(), connectors, false, bridgeConfig.isHA(), bridgeConfig.getUser(), bridgeConfig.getPassword());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

