/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPConnectorDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Messaging14SubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class Messaging20SubsystemParser
extends Messaging14SubsystemParser {
    private static final Messaging20SubsystemParser INSTANCE = new Messaging20SubsystemParser();

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    private Messaging20SubsystemParser() {
    }

    @Override
    void processConnectors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block12;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block12;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode connectorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    connectorAddress.add("connector", name);
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    this.parseTransportConfiguration(reader, operation, true);
                    break;
                }
                case NETTY_CONNECTOR: {
                    connectorAddress.add("remote-connector", name);
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                case IN_VM_CONNECTOR: {
                    connectorAddress.add("in-vm-connector", name);
                    if (serverId != null) {
                        InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    }
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                case HTTP_CONNECTOR: {
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    connectorAddress.add("http-connector", name);
                    HTTPConnectorDefinition.SOCKET_BINDING.parseAndSetParameter(socketBinding, operation, (XMLStreamReader)reader);
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            operation.get("address").set(connectorAddress);
            updates.add(operation);
        }
    }

    @Override
    void processAcceptors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            String httpListener = null;
            int count = reader.getAttributeCount();
            block13: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block13;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block13;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block13;
                    }
                    case HTTP_LISTENER: {
                        httpListener = attrValue;
                        continue block13;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode acceptorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    acceptorAddress.add("acceptor", name);
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    this.parseTransportConfiguration(reader, operation, true);
                    break;
                }
                case NETTY_ACCEPTOR: {
                    acceptorAddress.add("remote-acceptor", name);
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                case IN_VM_ACCEPTOR: {
                    acceptorAddress.add("in-vm-acceptor", name);
                    if (serverId != null) {
                        InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    }
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                case HTTP_ACCEPTOR: {
                    if (httpListener == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.HTTP_LISTENER));
                    }
                    acceptorAddress.add("http-acceptor", name);
                    HTTPAcceptorDefinition.HTTP_LISTENER.parseAndSetParameter(httpListener, operation, (XMLStreamReader)reader);
                    this.parseTransportConfiguration(reader, operation, false);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            operation.get("address").set(acceptorAddress);
            updates.add(operation);
        }
    }

    @Override
    protected void handleUnknownBridgeAttribute(XMLExtendedStreamReader reader, Element element, ModelNode bridgeAdd) throws XMLStreamException {
        switch (element) {
            case RECONNECT_ATTEMPTS_ON_SAME_NODE: {
                Messaging20SubsystemParser.handleElementText(reader, element, bridgeAdd);
                break;
            }
            default: {
                super.handleUnknownBridgeAttribute(reader, element, bridgeAdd);
            }
        }
    }

    @Override
    protected void handleUnknownAddressSetting(XMLExtendedStreamReader reader, Element element, ModelNode addressSettingsAdd) throws XMLStreamException {
        switch (element) {
            case EXPIRY_DELAY: {
                Messaging20SubsystemParser.handleElementText(reader, element, addressSettingsAdd);
                break;
            }
            default: {
                super.handleUnknownAddressSetting(reader, element, addressSettingsAdd);
            }
        }
    }
}

