/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.MessagingMessages;

public class ConnectionFactoryAttribute {
    private final AttributeDefinition attributeDefinition;
    private String propertyName;
    private final boolean resourceAdapterProperty;
    private final boolean inboundConfig;

    public static ConnectionFactoryAttribute create(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty) {
        return new ConnectionFactoryAttribute(attributeDefinition, propertyName, resourceAdapterProperty, false);
    }

    public static ConnectionFactoryAttribute create(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty, boolean inboundConfig) {
        return new ConnectionFactoryAttribute(attributeDefinition, propertyName, resourceAdapterProperty, inboundConfig);
    }

    public static AttributeDefinition[] getDefinitions(ConnectionFactoryAttribute ... attrs) {
        AttributeDefinition[] definitions = new AttributeDefinition[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            ConnectionFactoryAttribute attr = attrs[i];
            definitions[i] = attr.getDefinition();
        }
        return definitions;
    }

    private ConnectionFactoryAttribute(AttributeDefinition attributeDefinition, String propertyName, boolean resourceAdapterProperty, boolean inboundConfig) {
        this.attributeDefinition = attributeDefinition;
        this.propertyName = propertyName;
        this.resourceAdapterProperty = resourceAdapterProperty;
        this.inboundConfig = inboundConfig;
    }

    public String getClassType() {
        switch (this.attributeDefinition.getType()) {
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case BIG_DECIMAL: {
                return Double.class.getName();
            }
            case LONG: {
                return Long.class.getName();
            }
            case INT: {
                return Integer.class.getName();
            }
            case STRING: {
                return String.class.getName();
            }
        }
        throw MessagingMessages.MESSAGES.invalidAttributeType(this.attributeDefinition.getName(), this.attributeDefinition.getType());
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public AttributeDefinition getDefinition() {
        return this.attributeDefinition;
    }

    public boolean isResourceAdapterProperty() {
        return this.resourceAdapterProperty;
    }

    public boolean isInboundConfig() {
        return this.inboundConfig;
    }
}

