/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.enterprise.concurrent.ContextService;
import org.jboss.as.ee.concurrent.handle.ContextHandle;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.invocation.InterceptorContext;

public class EJBContextHandleFactory
implements ContextHandleFactory {
    public static final String NAME = "EJB";
    public static final EJBContextHandleFactory INSTANCE = new EJBContextHandleFactory();

    private EJBContextHandleFactory() {
    }

    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        return new EJBContextHandle();
    }

    public String getName() {
        return NAME;
    }

    public int getChainPriority() {
        return 500;
    }

    public void writeHandle(ContextHandle contextHandle, ObjectOutputStream out) throws IOException {
        out.writeObject(contextHandle);
    }

    public ContextHandle readHandle(ObjectInputStream in) throws IOException, ClassNotFoundException {
        return (ContextHandle)in.readObject();
    }

    private static class EJBContextHandle
    implements ContextHandle {
        private final transient InterceptorContext interceptorContext = CurrentInvocationContext.get();

        private EJBContextHandle() {
        }

        public String getFactoryName() {
            return EJBContextHandleFactory.NAME;
        }

        public void setup() throws IllegalStateException {
            if (this.interceptorContext != null) {
                CurrentInvocationContext.push(this.interceptorContext);
            }
        }

        public void reset() {
            if (this.interceptorContext != null) {
                CurrentInvocationContext.pop();
            }
        }
    }
}

