/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

class DefaultStatefulBeanAccessTimeoutWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    static final DefaultStatefulBeanAccessTimeoutWriteHandler INSTANCE = new DefaultStatefulBeanAccessTimeoutWriteHandler();

    private DefaultStatefulBeanAccessTimeoutWriteHandler() {
        super(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_ACCESS_TIMEOUT});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateOrCreateDefaultStatefulBeanAccessTimeoutService(context, model, null);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateOrCreateDefaultStatefulBeanAccessTimeoutService(context, restored, null);
    }

    void updateOrCreateDefaultStatefulBeanAccessTimeoutService(OperationContext context, ModelNode model, List<ServiceController<?>> newControllers) throws OperationFailedException {
        long defaultAccessTimeout = EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_ACCESS_TIMEOUT.resolveModelAttribute(context, model).asLong();
        ServiceName serviceName = DefaultAccessTimeoutService.STATEFUL_SERVICE_NAME;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null) {
            DefaultAccessTimeoutService defaultAccessTimeoutService = (DefaultAccessTimeoutService)DefaultAccessTimeoutService.class.cast(sc.getValue());
            defaultAccessTimeoutService.setDefaultAccessTimeout(defaultAccessTimeout);
        } else {
            DefaultAccessTimeoutService defaultAccessTimeoutService = new DefaultAccessTimeoutService(defaultAccessTimeout);
            ServiceController newService = context.getServiceTarget().addService(serviceName, (Service)defaultAccessTimeoutService).install();
            if (newControllers != null) {
                newControllers.add(newService);
            }
        }
    }
}

