/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.wildfly.clustering.web.annotation.Immutable;

public class CacheMutator<K, V>
implements Mutator {
    private static List<Object> IMMUTABLE_VALUES = Arrays.asList(null, Collections.EMPTY_LIST, Collections.EMPTY_MAP, Collections.EMPTY_SET);
    private static List<Class<?>> IMMUTABLE_TYPES = Arrays.asList(BigDecimal.class, BigInteger.class, Boolean.class, Byte.class, Character.class, Currency.class, Double.class, Enum.class, File.class, Float.class, InetAddress.class, InetSocketAddress.class, Integer.class, Locale.class, Long.class, MathContext.class, Path.class, Permission.class, Short.class, StackTraceElement.class, String.class, TimeZone.class, URI.class, URL.class, UUID.class);
    private final Cache<K, V> cache;
    private final CacheInvoker invoker;
    private final K id;
    private final V value;
    private final Set<Flag> flags;
    private final AtomicBoolean mutated = new AtomicBoolean(false);

    public CacheMutator(Cache<K, V> cache, CacheInvoker invoker, K id, V value, Flag ... flags) {
        this.cache = cache;
        this.invoker = invoker;
        this.id = id;
        this.value = value;
        this.flags = EnumSet.of(Flag.IGNORE_RETURN_VALUES, flags);
    }

    public void mutate() {
        if (this.mutated.compareAndSet(false, true)) {
            this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Mutator.MutateOperation(this.id, this.value), this.flags.toArray(new Flag[this.flags.size()]));
        }
    }

    public static boolean isMutable(Object object) {
        for (Object object2 : IMMUTABLE_VALUES) {
            if (object != object2) continue;
            return false;
        }
        for (Class clazz : IMMUTABLE_TYPES) {
            if (!clazz.isInstance(object)) continue;
            return false;
        }
        return !object.getClass().isAnnotationPresent(Immutable.class);
    }
}

