/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.KeyFilter;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.concurrent.Scheduler;
import org.jboss.as.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.web.Batch;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleImmutableSession;
import org.wildfly.clustering.web.infinispan.session.Time;
import org.wildfly.clustering.web.session.ImmutableHttpSessionAdapter;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionAttributes;
import org.wildfly.clustering.web.session.SessionContext;
import org.wildfly.clustering.web.session.SessionIdentifierFactory;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

@Listener
public class InfinispanSessionManager<V, L>
implements SessionManager<L>,
KeyGenerator<String>,
Batcher,
KeyFilter {
    private final SessionContext context;
    final Cache<String, V> cache;
    private final SessionFactory<V, L> factory;
    private final SessionIdentifierFactory idFactory;
    private final KeyAffinityService<String> affinity;
    private final Registry<String, Void> registry;
    private final NodeFactory<Address> nodeFactory;
    private final List<Scheduler<ImmutableSession>> schedulers = new CopyOnWriteArrayList<Scheduler<ImmutableSession>>();
    private final int maxActiveSessions;
    private volatile Time defaultMaxInactiveInterval = new Time(30L, TimeUnit.MINUTES);
    private final boolean persistent;

    public InfinispanSessionManager(SessionContext context, SessionIdentifierFactory idFactory, Cache<String, V> cache, SessionFactory<V, L> factory, KeyAffinityServiceFactory affinityFactory, Registry<String, Void> registry, NodeFactory<Address> nodeFactory, JBossWebMetaData metaData) {
        this.context = context;
        this.factory = factory;
        this.idFactory = idFactory;
        this.cache = cache;
        this.affinity = affinityFactory.createService(this.cache, (KeyGenerator)this);
        this.registry = registry;
        this.nodeFactory = nodeFactory;
        this.maxActiveSessions = metaData.getMaxActiveSessions();
        Configuration config = cache.getCacheConfiguration();
        this.persistent = config.clustering().cacheMode().isClustered() || config.persistence().usingStores() && !config.persistence().passivation();
    }

    public void start() {
        this.cache.addListener((Object)this, (KeyFilter)this);
        this.affinity.start();
        this.schedulers.add(new SessionExpirationScheduler(this, new ExpiredSessionRemover<V, L>(this.factory)));
        if (this.maxActiveSessions >= 0) {
            this.schedulers.add(new SessionEvictionScheduler(this, this.factory, this.maxActiveSessions));
        }
    }

    public void stop() {
        for (Scheduler<ImmutableSession> scheduler : this.schedulers) {
            scheduler.close();
        }
        this.schedulers.clear();
        this.affinity.stop();
        this.cache.removeListener((Object)this);
    }

    public boolean accept(Object key) {
        return key instanceof String;
    }

    public Batch startBatch() {
        final boolean started = this.cache.startBatch();
        return new Batch(){

            public void close() {
                this.end(true);
            }

            public void discard() {
                this.end(false);
            }

            private void end(boolean success) {
                if (started) {
                    InfinispanSessionManager.this.cache.endBatch(success);
                }
            }
        };
    }

    public String locate(String sessionId) {
        if (this.registry == null) {
            return null;
        }
        Map.Entry entry = null;
        Address location = this.locatePrimaryOwner(sessionId);
        if (location != null && this.nodeFactory != null) {
            Node node = this.nodeFactory.createNode((Object)location);
            entry = this.registry.getEntry(node);
        }
        if (entry == null) {
            entry = this.registry.getLocalEntry();
        }
        return entry != null ? (String)entry.getKey() : null;
    }

    private Address locatePrimaryOwner(String sessionId) {
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        return dist != null ? dist.getPrimaryLocation((Object)sessionId) : this.cache.getCacheManager().getAddress();
    }

    public Batcher getBatcher() {
        return this;
    }

    public long getDefaultMaxInactiveInterval(TimeUnit unit) {
        return this.defaultMaxInactiveInterval.convert(unit);
    }

    public void setDefaultMaxInactiveInterval(long value, TimeUnit unit) {
        this.defaultMaxInactiveInterval = new Time(value, unit);
    }

    public String getKey() {
        return this.idFactory.createSessionId();
    }

    public String createSessionId() {
        return (String)this.affinity.getKeyForAddress(this.cache.getCacheManager().getAddress());
    }

    public boolean containsSession(String id) {
        return this.cache.containsKey((Object)id);
    }

    public Session<L> findSession(String id) {
        Object value = this.factory.findValue(id);
        if (value == null) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s not found", id);
            return null;
        }
        Session<L> session = this.factory.createSession(id, value);
        if (session.getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was found, but has expired", id);
            session.invalidate();
            return null;
        }
        for (Scheduler<ImmutableSession> scheduler : this.schedulers) {
            scheduler.cancel(session);
        }
        if (this.persistent) {
            InfinispanSessionManager.triggerPostActivationEvents(session);
        }
        return new SchedulableSession<L>(session, this.schedulers, this.persistent);
    }

    public Session<L> createSession(String id) {
        Session<L> session = this.factory.createSession(id, this.factory.createValue(id));
        Time time = this.defaultMaxInactiveInterval;
        session.getMetaData().setMaxInactiveInterval(time.getValue(), time.getUnit());
        return new SchedulableSession<L>(session, this.schedulers, this.persistent);
    }

    public ImmutableSession viewSession(String id) {
        Object value = this.factory.findValue(id);
        return value != null ? new SimpleImmutableSession(this.factory.createImmutableSession(id, value)) : null;
    }

    public Set<String> getActiveSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING);
    }

    public Set<String> getLocalSessions() {
        return this.getSessions(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING);
    }

    private Set<String> getSessions(Flag ... flags) {
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.cache.getAdvancedCache().withFlags(flags).keySet()) {
            if (!(key instanceof String)) continue;
            result.add((String)key);
        }
        return result;
    }

    @CacheEntryActivated
    public void activated(CacheEntryActivatedEvent<String, ?> event) {
        if (!event.isPre() && !this.persistent) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s was activated", id);
            ImmutableSession session = this.factory.createImmutableSession(id, this.factory.findValue(id));
            InfinispanSessionManager.triggerPostActivationEvents(session);
        }
    }

    @CacheEntryPassivated
    public void passivated(CacheEntryPassivatedEvent<String, ?> event) {
        if (event.isPre() && !this.persistent) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be passivated", id);
            Session<L> session = this.factory.createSession(id, this.factory.findValue(id));
            InfinispanSessionManager.triggerPrePassivationEvents(session);
        }
    }

    @CacheEntryRemoved
    public void removed(CacheEntryRemovedEvent<String, ?> event) {
        if (event.isPre() && event.isOriginLocal()) {
            String id = (String)event.getKey();
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s will be removed", id);
            ImmutableSession session = this.factory.createImmutableSession(id, this.factory.findValue(id));
            ImmutableSessionAttributes attributes = session.getAttributes();
            ImmutableHttpSessionAdapter httpSession = new ImmutableHttpSessionAdapter(session);
            HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)httpSession);
            for (HttpSessionListener listener : this.context.getSessionListeners()) {
                listener.sessionDestroyed(sessionEvent);
            }
            for (String attribute : attributes.getAttributeNames()) {
                Object value = attributes.getAttribute(attribute);
                if (!(value instanceof HttpSessionBindingListener)) continue;
                HttpSessionBindingListener listener = (HttpSessionBindingListener)value;
                listener.valueUnbound(new HttpSessionBindingEvent((HttpSession)httpSession, attribute, value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<String, ?> event) {
        if (event.isPre()) {
            return;
        }
        Cache cache = event.getCache();
        Address localAddress = cache.getCacheManager().getAddress();
        ConsistentHash oldHash = event.getConsistentHashAtStart();
        ConsistentHash newHash = event.getConsistentHashAtEnd();
        HashSet oldAddresses = new HashSet(oldHash.getMembers());
        oldAddresses.removeAll(newHash.getMembers());
        if (!oldAddresses.isEmpty()) {
            for (Object key : cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD, Flag.SKIP_LOCKING}).keySet()) {
                String sessionId;
                Address oldOwner;
                if (!this.accept(key) || !oldAddresses.contains(oldOwner = oldHash.locatePrimaryOwner((Object)(sessionId = (String)key)))) continue;
                Address newOwner = newHash.locatePrimaryOwner((Object)sessionId);
                if (localAddress.equals(newOwner)) {
                    boolean started = cache.startBatch();
                    try {
                        Object value = this.factory.findValue(sessionId);
                        if (value == null) continue;
                        InfinispanWebLogger.ROOT_LOGGER.debugf("Scheduling expiration of session %s on behalf of previous owner: %s", sessionId, oldOwner);
                        ImmutableSession session = this.factory.createImmutableSession(sessionId, value);
                        for (Scheduler<ImmutableSession> scheduler : this.schedulers) {
                            scheduler.cancel((Object)session);
                            scheduler.schedule((Object)session);
                        }
                        continue;
                    }
                    finally {
                        if (started) {
                            cache.endBatch(false);
                        }
                        continue;
                    }
                }
                InfinispanWebLogger.ROOT_LOGGER.tracef("Expiration of session %s will be scheduled by node %s on behalf of previous owner: %s", sessionId, newOwner, oldOwner);
            }
        }
    }

    static void triggerPrePassivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
            for (HttpSessionActivationListener listener : listeners) {
                listener.sessionWillPassivate(event);
            }
        }
    }

    static void triggerPostActivationEvents(ImmutableSession session) {
        List<HttpSessionActivationListener> listeners = InfinispanSessionManager.findListeners(session);
        if (!listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)new ImmutableHttpSessionAdapter(session));
            for (HttpSessionActivationListener listener : listeners) {
                listener.sessionDidActivate(event);
            }
        }
    }

    private static List<HttpSessionActivationListener> findListeners(ImmutableSession session) {
        ImmutableSessionAttributes attributes = session.getAttributes();
        Set names = attributes.getAttributeNames();
        ArrayList<HttpSessionActivationListener> listeners = new ArrayList<HttpSessionActivationListener>(names.size());
        for (String name : names) {
            Object attribute = attributes.getAttribute(name);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            listeners.add((HttpSessionActivationListener)attribute);
        }
        return listeners;
    }

    private static class SchedulableSession<L>
    implements Session<L> {
        private final Session<L> session;
        private final List<Scheduler<ImmutableSession>> schedulers;
        private final boolean persistent;

        SchedulableSession(Session<L> session, List<Scheduler<ImmutableSession>> schedulers, boolean persistent) {
            this.session = session;
            this.schedulers = schedulers;
            this.persistent = persistent;
        }

        public String getId() {
            return this.session.getId();
        }

        public SessionMetaData getMetaData() {
            return this.session.getMetaData();
        }

        public boolean isValid() {
            return this.session.isValid();
        }

        public void invalidate() {
            this.session.invalidate();
        }

        public SessionAttributes getAttributes() {
            return this.session.getAttributes();
        }

        public SessionContext getContext() {
            return this.session.getContext();
        }

        public void close() {
            if (this.persistent) {
                InfinispanSessionManager.triggerPrePassivationEvents(this.session);
            }
            this.session.close();
            for (Scheduler<ImmutableSession> scheduler : this.schedulers) {
                scheduler.schedule(this.session);
            }
        }

        public L getLocalContext() {
            return (L)this.session.getLocalContext();
        }
    }
}

