/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.web.infinispan.session.Time;
import org.wildfly.clustering.web.session.SessionMetaData;

public class SimpleSessionMetaData
implements SessionMetaData {
    private final Date creationTime;
    private volatile Date lastAccessedTime;
    private volatile Time maxInactiveInterval;

    public SimpleSessionMetaData() {
        Date now;
        this.creationTime = now = new Date();
        this.lastAccessedTime = now;
        this.maxInactiveInterval = new Time(0L, TimeUnit.MILLISECONDS);
    }

    public SimpleSessionMetaData(Date creationTime, Date lastAccessedTime, Time maxInactiveInterval) {
        this.creationTime = creationTime;
        this.lastAccessedTime = lastAccessedTime;
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public boolean isExpired() {
        long maxInactiveInterval = this.getMaxInactiveInterval(TimeUnit.MILLISECONDS);
        return maxInactiveInterval > 0L ? System.currentTimeMillis() - this.lastAccessedTime.getTime() > maxInactiveInterval : false;
    }

    public boolean isNew() {
        return this.lastAccessedTime == this.creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(Date date) {
        this.lastAccessedTime = date;
    }

    public long getMaxInactiveInterval(TimeUnit unit) {
        return this.maxInactiveInterval.convert(unit);
    }

    public void setMaxInactiveInterval(long interval, TimeUnit unit) {
        this.maxInactiveInterval = new Time(interval, unit);
    }
}

