/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.Creator;
import org.jboss.as.clustering.infinispan.invoker.Locator;
import org.jboss.as.clustering.infinispan.invoker.Remover;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSO;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.SSOMutator;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOCacheEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.sso.SSO;

public class CoarseSSOFactory<L>
implements SSOFactory<CoarseSSOCacheEntry<L>, L> {
    private final Cache<String, CoarseSSOCacheEntry<L>> cache;
    private final CacheInvoker invoker;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSSOFactory(Cache<String, CoarseSSOCacheEntry<L>> cache, CacheInvoker invoker, LocalContextFactory<L> localContextFactory) {
        this.cache = cache;
        this.invoker = invoker;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public SSO<L> createSSO(String id, CoarseSSOCacheEntry<L> value) {
        SSOMutator<CoarseSSOCacheEntry<L>> mutator = new SSOMutator<CoarseSSOCacheEntry<L>>(this.cache, this.invoker, id, value);
        CoarseSessions sessions = new CoarseSessions(value.getSessions(), mutator);
        return new InfinispanSSO<L>(id, value, sessions, value.getLocalContext(), this.localContextFactory, this);
    }

    public CoarseSSOCacheEntry<L> createValue(String id) {
        CoarseSSOCacheEntry entry = new CoarseSSOCacheEntry();
        CoarseSSOCacheEntry existing = (CoarseSSOCacheEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Creator.CreateOperation((Object)id, entry), new Flag[0]);
        return existing != null ? existing : entry;
    }

    public CoarseSSOCacheEntry<L> findValue(String id) {
        return (CoarseSSOCacheEntry)this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Locator.FindOperation((Object)id), new Flag[0]);
    }

    public void remove(String id) {
        this.invoker.invoke(this.cache, (CacheInvoker.Operation)new Remover.RemoveOperation((Object)id), new Flag[]{Flag.IGNORE_RETURN_VALUES});
    }
}

