/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.picketlink.idm.file.internal.AbstractFileType;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;

public class FileAttribute
extends AbstractFileType<Collection<Attribute<? extends Serializable>>> {
    private static final String VERSION = "1";
    private String identityTypeId;

    protected FileAttribute(AttributedType identityType) {
        super(VERSION, Collections.synchronizedList(new ArrayList(identityType.getAttributes())));
        this.identityTypeId = identityType.getId();
    }

    @Override
    protected Collection<Attribute<? extends Serializable>> doPopulateEntry(Map<String, Serializable> properties) throws Exception {
        ArrayList<Attribute<? extends Serializable>> attributes = new ArrayList<Attribute<? extends Serializable>>();
        for (String name : properties.keySet()) {
            attributes.add((Attribute<? extends Serializable>)new Attribute(name, properties.get(name)));
        }
        return attributes;
    }

    @Override
    protected void doWriteObject(ObjectOutputStream s) throws Exception {
        super.doWriteObject(s);
        s.writeObject(this.identityTypeId);
    }

    @Override
    protected void doReadObject(ObjectInputStream s) throws Exception {
        super.doReadObject(s);
        this.identityTypeId = s.readObject().toString();
    }

    @Override
    protected void doPopulateProperties(Map<String, Serializable> properties) throws Exception {
        for (Attribute attribute : new ArrayList((Collection)this.getEntry())) {
            properties.put(attribute.getName(), attribute.getValue());
        }
    }
}

