/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.ToolErrorListener;

public class ToolException
extends RuntimeException {
    private static final long serialVersionUID = -4418907917249006910L;
    List<Throwable> suppressed = new ArrayList<Throwable>(0);
    boolean hasSuppressed;

    public ToolException() {
    }

    public ToolException(String message, List<ToolErrorListener.ErrorInfo> e) {
        super(message);
        if (e.size() > 1) {
            for (ToolErrorListener.ErrorInfo er : e) {
                String ms = this.createMessage(er);
                if (ms != null && er.cause != null && ms.equals(er.cause.getLocalizedMessage())) {
                    this.addSuppressedThrowable(er.cause);
                    continue;
                }
                if (ms == null && er.cause != null) {
                    this.addSuppressedThrowable(er.cause);
                    continue;
                }
                this.addSuppressedThrowable(new ToolException(ms, er.cause));
            }
        } else if (e.size() == 1) {
            this.initCause(e.get((int)0).cause);
        }
    }

    public ToolException(Message msg) {
        super(msg.toString());
    }

    public ToolException(String msg) {
        super(msg);
    }

    public ToolException(Message msg, Throwable t) {
        super(msg.toString(), t);
    }

    public ToolException(String msg, Throwable t) {
        super(msg, t);
    }

    public ToolException(Throwable t) {
        super(t);
    }

    public ToolException(String messageId, Logger logger) {
        this(new Message(messageId, logger, new Object[0]));
    }

    public ToolException(String messageId, Logger logger, Object ... args) {
        this(new Message(messageId, logger, args));
    }

    private String createMessage(ToolErrorListener.ErrorInfo e) {
        if (e.file != null) {
            return e.file + " [" + e.line + "," + e.col + "]: " + e.message;
        }
        if (e.message == null && e.cause != null) {
            return e.cause.getLocalizedMessage();
        }
        return e.message;
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        if (!this.hasSuppressed) {
            super.printStackTrace(ps);
            return;
        }
        this.printStackTrace(ps, "", "");
    }

    public void printStackTrace(PrintStream ps, String pfx, String cap) {
        StackTraceElement[] trace;
        ps.println(pfx + cap + this);
        for (StackTraceElement traceElement : trace = super.getStackTrace()) {
            ps.println(pfx + "\tat " + traceElement);
        }
        for (Throwable se : this.suppressed) {
            this.printThrowable(se, ps, pfx + "/t", "Suppressed: ");
        }
        Throwable ourCause = this.getCause();
        if (!(ourCause == null || this.hasSuppressed && ourCause == this.suppressed.get(0))) {
            this.printThrowable(ourCause, ps, pfx + "/t", "Caused by: ");
        }
    }

    private void printThrowable(Throwable t, PrintStream ps, String pfx, String cap) {
        if (t instanceof ToolException) {
            ((ToolException)t).printStackTrace(ps, pfx, cap);
        } else {
            StackTraceElement[] trace;
            ps.println(pfx + cap + t);
            for (StackTraceElement ste : trace = t.getStackTrace()) {
                ps.println(pfx + "\tat " + ste);
            }
            if (t.getCause() != null) {
                this.printThrowable(t.getCause(), ps, pfx + "\t", "Caused by: ");
            }
        }
    }

    private void addSuppressedThrowable(Throwable t) {
        try {
            this.getClass().getMethod("addSuppressed", Throwable.class).invoke((Object)this, t);
        }
        catch (Throwable t2) {
            this.suppressed.add(t2);
            if (this.getCause() == null) {
                this.initCause(t);
            }
            this.hasSuppressed = true;
        }
    }
}

