/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommandDocument {
    private static final Logger LOG = LogUtils.getL7dLogger(CommandDocument.class);
    private final Document doc;
    private final ToolSpec toolspec;
    private final List<Element> values;

    CommandDocument(ToolSpec ts, Document d) {
        int i;
        if (ts == null) {
            throw new NullPointerException("CommandDocument cannot be created with a null toolspec");
        }
        this.toolspec = ts;
        if (d == null) {
            throw new NullPointerException("CommandDocument cannot be created with a null document");
        }
        this.values = new ArrayList<Element>();
        this.doc = d;
        NodeList nl = this.doc.getDocumentElement().getElementsByTagName("option");
        for (i = 0; i < nl.getLength(); ++i) {
            this.values.add((Element)nl.item(i));
        }
        nl = this.doc.getDocumentElement().getElementsByTagName("argument");
        for (i = 0; i < nl.getLength(); ++i) {
            this.values.add((Element)nl.item(i));
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public boolean hasParameter(String name) {
        return this.getParameters(name).length > 0;
    }

    public String getParameter(String name) {
        String[] res;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting parameter " + name);
        }
        if ((res = this.getParameters(name)).length == 0) {
            return null;
        }
        return res[0];
    }

    public String[] getParameters(String name) {
        String def;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting parameters for " + name);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.values != null) {
            for (Element el : this.values) {
                if (!el.getAttribute("name").equals(name)) continue;
                if (el.hasChildNodes()) {
                    result.add(el.getFirstChild().getNodeValue());
                    continue;
                }
                result.add("true");
            }
        }
        if (result.isEmpty() && (def = this.toolspec.getParameterDefault(name)) != null) {
            result.add(def);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.values != null) {
            for (Element el : this.values) {
                result.add(el.getAttribute("name"));
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

