/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MessageContext<E extends MessageContext> {
    protected final E parentContext;
    private final String fieldName;
    private String fullFieldName;
    protected final Descriptors.Descriptor messageDescriptor;
    protected final Map<String, Descriptors.FieldDescriptor> fieldDescriptors;
    protected final Set<Integer> seenFields;

    protected MessageContext(E parentContext, String fieldName, Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        if (parentContext != null && fieldName == null) {
            throw new IllegalArgumentException("fieldName cannot be null for nested contexts");
        }
        if (parentContext == null && fieldName != null) {
            throw new IllegalArgumentException("fieldName must be null for root contexts");
        }
        this.parentContext = parentContext;
        this.fieldName = fieldName;
        this.messageDescriptor = messageDescriptor;
        List fields = messageDescriptor.getFields();
        this.seenFields = new HashSet<Integer>(fields.size());
        this.fieldDescriptors = new HashMap<String, Descriptors.FieldDescriptor>(fields.size());
        for (Descriptors.FieldDescriptor fd : fields) {
            this.fieldDescriptors.put(fd.getName(), fd);
        }
    }

    public E getParentContext() {
        return this.parentContext;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFullFieldName() {
        if (this.fieldName == null) {
            return null;
        }
        if (this.fullFieldName == null) {
            String pfqn = null;
            if (this.parentContext != null) {
                pfqn = ((MessageContext)this.parentContext).getFullFieldName();
            }
            this.fullFieldName = pfqn != null ? pfqn + "." + this.fieldName : this.fieldName;
        }
        return this.fullFieldName;
    }

    public Descriptors.Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public Map<String, Descriptors.FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public Descriptors.FieldDescriptor getFieldByName(String fieldName) {
        Descriptors.FieldDescriptor fd = this.fieldDescriptors.get(fieldName);
        if (fd == null) {
            throw new IllegalArgumentException("Unknown field : " + fieldName);
        }
        return fd;
    }

    public Descriptors.FieldDescriptor getFieldByNumber(int fieldNumber) {
        Descriptors.FieldDescriptor fd = this.messageDescriptor.findFieldByNumber(fieldNumber);
        if (fd == null) {
            throw new IllegalArgumentException("Unknown field : " + this.fieldName);
        }
        return fd;
    }

    public Set<Integer> getSeenFields() {
        return this.seenFields;
    }
}

