/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.impl.WriteMessageContext;

public final class ProtoStreamWriterImpl
implements MessageMarshaller.ProtoStreamWriter {
    private final SerializationContext ctx;
    private WriteMessageContext messageContext;

    public ProtoStreamWriterImpl(SerializationContext ctx) {
        this.ctx = ctx;
    }

    public void write(CodedOutputStream out, Object t) throws IOException {
        this.resetContext();
        if (t instanceof MessageLite) {
            ((MessageLite)t).writeTo(out);
        } else {
            BaseMarshaller<?> marshaller = this.ctx.getMarshaller(t.getClass());
            Descriptors.Descriptor messageDescriptor = this.ctx.getMessageDescriptor(marshaller.getTypeName());
            this.enterContext(null, messageDescriptor, out);
            this.marshall(t, marshaller, out);
            this.exitContext();
        }
        out.flush();
    }

    private void marshall(Object value, BaseMarshaller marshaller, CodedOutputStream out) throws IOException {
        UnknownFieldSet unknownFieldSet;
        if (marshaller instanceof MessageMarshaller) {
            ((MessageMarshaller)marshaller).writeTo(this, value);
        } else {
            ((RawProtobufMarshaller)marshaller).writeTo(this.ctx, out, value);
        }
        if (value instanceof Message && (unknownFieldSet = ((Message)value).getUnknownFieldSet()) != null) {
            unknownFieldSet.writeTo(this.messageContext.out);
        }
    }

    private void resetContext() {
        this.messageContext = null;
    }

    private void enterContext(String fieldName, Descriptors.Descriptor messageDescriptor, CodedOutputStream out) {
        this.messageContext = new WriteMessageContext(this.messageContext, fieldName, messageDescriptor, out);
    }

    private void exitContext() {
        for (Descriptors.FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            if (!fd.isRequired() || this.messageContext.getSeenFields().contains(fd.getNumber())) continue;
            throw new IllegalStateException("Required field \"" + fd.getName() + "\" should have been written by a calling one of " + MessageMarshaller.ProtoStreamWriter.class.getName() + " writeXYZ(..) methods");
        }
        this.messageContext = (WriteMessageContext)this.messageContext.getParentContext();
    }

    @Override
    public void writeInt(String fieldName, Integer value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeInt(fieldName, (int)value);
    }

    @Override
    public void writeInt(String fieldName, int value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case INT32: {
                this.messageContext.out.writeInt32(fd.getNumber(), value);
                break;
            }
            case FIXED32: {
                this.messageContext.out.writeFixed32(fd.getNumber(), value);
                break;
            }
            case UINT32: {
                this.messageContext.out.writeUInt32(fd.getNumber(), value);
                break;
            }
            case SFIXED32: {
                this.messageContext.out.writeSFixed32(fd.getNumber(), value);
                break;
            }
            case SINT32: {
                this.messageContext.out.writeSInt32(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, long value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case INT64: {
                this.messageContext.out.writeInt64(fd.getNumber(), value);
                break;
            }
            case UINT64: {
                this.messageContext.out.writeUInt64(fd.getNumber(), value);
                break;
            }
            case FIXED64: {
                this.messageContext.out.writeFixed64(fd.getNumber(), value);
                break;
            }
            case SFIXED64: {
                this.messageContext.out.writeSFixed64(fd.getNumber(), value);
                break;
            }
            case SINT64: {
                this.messageContext.out.writeSInt64(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeLong(String fieldName, Long value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeLong(fieldName, (long)value);
    }

    @Override
    public void writeDouble(String fieldName, double value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case DOUBLE: {
                this.messageContext.out.writeDouble(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeDouble(String fieldName, Double value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeDouble(fieldName, (double)value);
    }

    @Override
    public void writeFloat(String fieldName, float value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case FLOAT: {
                this.messageContext.out.writeFloat(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeFloat(String fieldName, Float value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeFloat(fieldName, value.floatValue());
    }

    @Override
    public void writeBoolean(String fieldName, boolean value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        this.checkFieldWrite(fd, false);
        switch (fd.getType()) {
            case BOOL: {
                this.messageContext.out.writeBool(fd.getNumber(), value);
                break;
            }
            default: {
                throw new IllegalArgumentException("The declared field type is not compatible with the written type : " + fieldName);
            }
        }
    }

    @Override
    public void writeBoolean(String fieldName, Boolean value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.writeBoolean(fieldName, (boolean)value);
    }

    private void writePrimitiveCollection(Descriptors.FieldDescriptor fd, Collection<?> collection, Class clazz) throws IOException {
        switch (fd.getType()) {
            case DOUBLE: {
                for (Object value : collection) {
                    this.messageContext.out.writeDouble(fd.getNumber(), ((Double)value).doubleValue());
                }
                break;
            }
            case FLOAT: {
                for (Object value : collection) {
                    this.messageContext.out.writeDouble(fd.getNumber(), ((Double)value).doubleValue());
                }
                break;
            }
            case BOOL: {
                for (Object value : collection) {
                    this.messageContext.out.writeBool(fd.getNumber(), ((Boolean)value).booleanValue());
                }
                break;
            }
            case STRING: {
                for (Object value : collection) {
                    this.messageContext.out.writeString(fd.getNumber(), (String)value);
                }
                break;
            }
            case BYTES: {
                for (Object value : collection) {
                    this.messageContext.out.writeBytes(fd.getNumber(), (ByteString)value);
                }
                break;
            }
            case INT64: {
                for (Object value : collection) {
                    this.messageContext.out.writeInt64(fd.getNumber(), ((Long)value).longValue());
                }
                break;
            }
            case UINT64: {
                for (Object value : collection) {
                    this.messageContext.out.writeUInt64(fd.getNumber(), ((Long)value).longValue());
                }
                break;
            }
            case FIXED64: {
                for (Object value : collection) {
                    this.messageContext.out.writeFixed64(fd.getNumber(), ((Long)value).longValue());
                }
                break;
            }
            case SFIXED64: {
                for (Object value : collection) {
                    this.messageContext.out.writeSFixed64(fd.getNumber(), ((Long)value).longValue());
                }
                break;
            }
            case SINT64: {
                for (Object value : collection) {
                    this.messageContext.out.writeSInt64(fd.getNumber(), ((Long)value).longValue());
                }
                break;
            }
            case INT32: {
                for (Object value : collection) {
                    this.messageContext.out.writeInt32(fd.getNumber(), ((Integer)value).intValue());
                }
                break;
            }
            case FIXED32: {
                for (Object value : collection) {
                    this.messageContext.out.writeFixed32(fd.getNumber(), ((Integer)value).intValue());
                }
                break;
            }
            case UINT32: {
                for (Object value : collection) {
                    this.messageContext.out.writeUInt32(fd.getNumber(), ((Integer)value).intValue());
                }
                break;
            }
            case SFIXED32: {
                for (Object value : collection) {
                    this.messageContext.out.writeSFixed32(fd.getNumber(), ((Integer)value).intValue());
                }
                break;
            }
            case SINT32: {
                for (Object value : collection) {
                    this.messageContext.out.writeSInt32(fd.getNumber(), ((Integer)value).intValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field type : " + fd.getType());
            }
        }
    }

    @Override
    public void writeString(String fieldName, String value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Descriptors.FieldDescriptor.Type.STRING) {
            throw new IllegalArgumentException("Declared field type is not of type String : " + fieldName);
        }
        this.messageContext.out.writeString(fd.getNumber(), value);
    }

    @Override
    public void writeBytes(String fieldName, byte[] value) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() != Descriptors.FieldDescriptor.Type.BYTES) {
            throw new IllegalArgumentException("Declared field type is not of type byte[] : " + fieldName);
        }
        this.messageContext.out.writeTag(fd.getNumber(), 2);
        this.messageContext.out.writeRawVarint32(value.length);
        this.messageContext.out.writeRawBytes(value);
    }

    public void writeObject(String fieldName, Object value, Class clazz) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (value == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, false);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            this.writeGroup(fd, value, clazz);
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            this.writeMessage(fd, value, clazz);
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            this.writeEnum(fd, (Enum)value);
        } else {
            throw new IllegalArgumentException("Declared field type is not a message or an enum : " + fieldName);
        }
    }

    private void writeMessage(Descriptors.FieldDescriptor fd, Object value, Class clazz) throws IOException {
        if (MessageLite.class.isAssignableFrom(clazz)) {
            this.messageContext.out.writeMessage(fd.getNumber(), (MessageLite)value);
        } else {
            BaseMarshaller marshaller = this.ctx.getMarshaller(clazz);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CodedOutputStream out = CodedOutputStream.newInstance((OutputStream)baos);
            this.enterContext(fd.getName(), fd.getMessageType(), out);
            this.marshall(value, marshaller, out);
            out.flush();
            this.exitContext();
            this.messageContext.out.writeTag(fd.getNumber(), 2);
            this.messageContext.out.writeRawVarint32(baos.size());
            this.messageContext.out.writeRawBytes(baos.toByteArray());
        }
    }

    private void writeGroup(Descriptors.FieldDescriptor fd, Object value, Class clazz) throws IOException {
        this.messageContext.out.writeTag(fd.getNumber(), 3);
        if (MessageLite.class.isAssignableFrom(clazz)) {
            this.messageContext.out.writeGroup(fd.getNumber(), (MessageLite)value);
        } else {
            this.enterContext(fd.getName(), fd.getMessageType(), this.messageContext.out);
            BaseMarshaller marshaller = this.ctx.getMarshaller(clazz);
            this.marshall(value, marshaller, this.messageContext.out);
            this.exitContext();
        }
        this.messageContext.out.writeTag(fd.getNumber(), 4);
    }

    private <T extends Enum<T>> void writeEnum(Descriptors.FieldDescriptor fd, T value) throws IOException {
        int enumValue;
        if (value instanceof ProtocolMessageEnum) {
            enumValue = ((ProtocolMessageEnum)value).getNumber();
        } else {
            EnumMarshaller encoder = (EnumMarshaller)this.ctx.getMarshaller(value.getClass());
            enumValue = encoder.encode(value);
        }
        boolean valid = false;
        for (Descriptors.EnumValueDescriptor evd : fd.getEnumType().getValues()) {
            if (evd.getIndex() != enumValue) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new IllegalArgumentException("Undefined enum value : " + value);
        }
        this.messageContext.out.writeEnum(fd.getNumber(), enumValue);
    }

    @Override
    public <T> void writeCollection(String fieldName, Collection<T> collection, Class<T> clazz) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (collection == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, true);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            for (T t : collection) {
                this.writeGroup(fd, t, clazz);
            }
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            for (T t : collection) {
                this.writeMessage(fd, t, clazz);
            }
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            for (T t : collection) {
                this.writeEnum(fd, (Enum)t);
            }
        } else {
            this.writePrimitiveCollection(fd, collection, clazz);
        }
    }

    @Override
    public <T> void writeArray(String fieldName, T[] array, Class<T> clazz) throws IOException {
        Descriptors.FieldDescriptor fd = this.messageContext.getFieldByName(fieldName);
        if (array == null) {
            if (fd.isRequired()) {
                throw new IllegalArgumentException("A required field cannot be null : " + fieldName);
            }
            return;
        }
        this.checkFieldWrite(fd, true);
        if (fd.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
            for (T t : array) {
                this.writeGroup(fd, t, clazz);
            }
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            for (T t : array) {
                this.writeMessage(fd, t, clazz);
            }
        } else if (fd.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
            for (T t : array) {
                this.writeEnum(fd, (Enum)t);
            }
        } else {
            this.writePrimitiveCollection(fd, Arrays.asList(array), clazz);
        }
    }

    private void checkFieldWrite(Descriptors.FieldDescriptor fd, boolean expectRepeated) {
        if (fd.isRepeated()) {
            if (!expectRepeated) {
                throw new IllegalArgumentException("A repeated field should be written with one of the methods intended for collections or arrays: " + fd.getName());
            }
        } else if (expectRepeated) {
            throw new IllegalArgumentException("This field is not repeated and cannot be written with one of the methods intended for collections or arrays: " + fd.getName());
        }
        if (!this.messageContext.getSeenFields().add(fd.getNumber())) {
            throw new IllegalArgumentException("Cannot write a field twice : " + fd.getName());
        }
    }
}

