/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.impl.WireFormat;

final class UnknownFieldSetImpl
implements UnknownFieldSet {
    private Map<Integer, UnknownField> fields = new TreeMap<Integer, UnknownField>();

    UnknownFieldSetImpl() {
    }

    private UnknownField addField(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        UnknownField field = this.fields.get(tag);
        if (field == null) {
            field = new UnknownField();
            this.fields.put(tag, field);
        }
        return field;
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public void mergeFrom(CodedInputStream input) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && this.mergeFieldFrom(tag, input)) {
        }
    }

    @Override
    public boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                this.addField(tag).addVarint(input.readInt64());
                return true;
            }
            case 1: {
                this.addField(tag).addFixed64(input.readFixed64());
                return true;
            }
            case 2: {
                this.addField(tag).addLengthDelimited(input.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetImpl unknownFieldSet = new UnknownFieldSetImpl();
                unknownFieldSet.mergeFrom(input);
                input.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4));
                this.addField(tag).addGroup(unknownFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.addField(tag).addFixed32(input.readFixed32());
                return true;
            }
        }
        throw new InvalidProtocolBufferException("Protocol message tag had invalid wire type " + wireType);
    }

    @Override
    public void mergeVarintField(int tag, int value) {
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag");
        }
        this.addField(tag).addVarint(value);
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        for (Map.Entry<Integer, UnknownField> entry : this.fields.entrySet()) {
            entry.getValue().writeTo(entry.getKey(), output);
        }
        output.flush();
    }

    public int getSerializedSize() {
        int result = 0;
        for (Map.Entry<Integer, UnknownField> entry : this.fields.entrySet()) {
            result += entry.getValue().getSerializedSize(entry.getKey());
        }
        return result;
    }

    @Override
    public <A> A consumeTag(int tag) {
        Deque values2;
        if (tag == 0) {
            throw new IllegalArgumentException("Zero is not a valid tag number");
        }
        UnknownField unknownField = this.fields.get(tag);
        if (unknownField == null) {
            return null;
        }
        int wireType = WireFormat.getTagWireType(tag);
        switch (wireType) {
            case 0: {
                values2 = unknownField.varint;
                break;
            }
            case 1: {
                values2 = unknownField.fixed64;
                break;
            }
            case 2: {
                values2 = unknownField.lengthDelimited;
                break;
            }
            case 3: {
                values2 = unknownField.group;
                break;
            }
            case 5: {
                Deque values2 = unknownField.fixed32;
            }
            default: {
                throw new IllegalArgumentException("Invalid wire type " + wireType);
            }
        }
        Object value = values2.poll();
        if (values2.isEmpty()) {
            this.fields.remove(tag);
        }
        return (A)value;
    }

    public static final class UnknownField {
        private Deque<Long> varint;
        private Deque<Integer> fixed32;
        private Deque<Long> fixed64;
        private Deque<ByteString> lengthDelimited;
        private Deque<UnknownFieldSetImpl> group;

        public void addVarint(long value) {
            if (this.varint == null) {
                this.varint = new ArrayDeque<Long>();
            }
            this.varint.add(value);
        }

        public void addFixed32(int value) {
            if (this.fixed32 == null) {
                this.fixed32 = new ArrayDeque<Integer>();
            }
            this.fixed32.add(value);
        }

        public void addFixed64(long value) {
            if (this.fixed64 == null) {
                this.fixed64 = new ArrayDeque<Long>();
            }
            this.fixed64.add(value);
        }

        public void addLengthDelimited(ByteString value) {
            if (this.lengthDelimited == null) {
                this.lengthDelimited = new ArrayDeque<ByteString>();
            }
            this.lengthDelimited.add(value);
        }

        public void addGroup(UnknownFieldSetImpl value) {
            if (this.group == null) {
                this.group = new ArrayDeque<UnknownFieldSetImpl>();
            }
            this.group.add(value);
        }

        public void writeTo(int tag, CodedOutputStream output) throws IOException {
            Iterator<Object> i$;
            if (this.varint != null) {
                i$ = this.varint.iterator();
                while (i$.hasNext()) {
                    long l = (Long)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeUInt64NoTag(l);
                }
            }
            if (this.fixed32 != null) {
                i$ = this.fixed32.iterator();
                while (i$.hasNext()) {
                    int n = (Integer)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeFixed32NoTag(n);
                }
            }
            if (this.fixed64 != null) {
                i$ = this.fixed64.iterator();
                while (i$.hasNext()) {
                    long l = (Long)i$.next();
                    output.writeRawVarint32(tag);
                    output.writeFixed64NoTag(l);
                }
            }
            if (this.lengthDelimited != null) {
                for (ByteString byteString : this.lengthDelimited) {
                    output.writeRawVarint32(tag);
                    output.writeBytesNoTag(byteString);
                }
            }
            if (this.group != null) {
                for (UnknownFieldSet unknownFieldSet : this.group) {
                    output.writeRawVarint32(tag);
                    unknownFieldSet.writeTo(output);
                    output.writeTag(WireFormat.getTagFieldNumber(tag), 4);
                }
            }
        }

        public int getSerializedSize(int fieldNumber) {
            Iterator<Object> i$;
            int result = 0;
            if (this.varint != null) {
                i$ = this.varint.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    result += CodedOutputStream.computeUInt64Size((int)fieldNumber, (long)value);
                }
            }
            if (this.fixed32 != null) {
                i$ = this.fixed32.iterator();
                while (i$.hasNext()) {
                    int value = (Integer)i$.next();
                    result += CodedOutputStream.computeFixed32Size((int)fieldNumber, (int)value);
                }
            }
            if (this.fixed64 != null) {
                i$ = this.fixed64.iterator();
                while (i$.hasNext()) {
                    long value = (Long)i$.next();
                    result += CodedOutputStream.computeFixed64Size((int)fieldNumber, (long)value);
                }
            }
            if (this.lengthDelimited != null) {
                for (ByteString value : this.lengthDelimited) {
                    result += CodedOutputStream.computeBytesSize((int)fieldNumber, (ByteString)value);
                }
            }
            if (this.group != null) {
                for (UnknownFieldSetImpl value : this.group) {
                    result += CodedOutputStream.computeTagSize((int)fieldNumber) << 1 + value.getSerializedSize();
                }
            }
            return result;
        }
    }
}

