/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.servlet.api.ServletInfo;
import org.apache.jasper.servlet.JspServlet;

public class JSPConfig {
    private final ServletInfo servletInfo;

    public JSPConfig(boolean developmentMode, boolean disabled, boolean keepGenerated, boolean trimSpaces, boolean tagPooling, boolean mappedFile, int checkInterval, int modificationTestInterval, boolean recompileOnFail, boolean smap, boolean dumpSmap, boolean genStringAsCharArray, boolean errorOnUseBeanInvalidClassAttribute, String scratchDir, String sourceVm, String targetVm, String javaEncoding, boolean xPoweredBy, boolean displaySourceFragment) {
        if (disabled) {
            this.servletInfo = null;
        } else {
            ServletInfo jspServlet = new ServletInfo("Default JSP Servlet", JspServlet.class).addMapping("*.jsp").addMapping("*.jspx");
            jspServlet.addInitParam("development", Boolean.toString(developmentMode));
            jspServlet.addInitParam("keepgenerated", Boolean.toString(keepGenerated));
            jspServlet.addInitParam("trimSpaces", Boolean.toString(trimSpaces));
            jspServlet.addInitParam("enablePooling", Boolean.toString(tagPooling));
            jspServlet.addInitParam("mappedfile", Boolean.toString(mappedFile));
            jspServlet.addInitParam("checkInterval", Integer.toString(checkInterval));
            jspServlet.addInitParam("modificationTestInterval", Integer.toString(modificationTestInterval));
            jspServlet.addInitParam("recompileOnFail", Boolean.toString(recompileOnFail));
            jspServlet.addInitParam("suppressSmap", Boolean.toString(!smap));
            jspServlet.addInitParam("dumpSmap", Boolean.toString(dumpSmap));
            jspServlet.addInitParam("genStringAsCharArray", Boolean.toString(genStringAsCharArray));
            jspServlet.addInitParam("errorOnUseBeanInvalidClassAttribute", Boolean.toString(errorOnUseBeanInvalidClassAttribute));
            if (scratchDir != null) {
                jspServlet.addInitParam("scratchdir", scratchDir);
            }
            jspServlet.addInitParam("compilerSourceVM", sourceVm);
            jspServlet.addInitParam("compilerTargetVM", targetVm);
            jspServlet.addInitParam("javaEncoding", javaEncoding);
            jspServlet.addInitParam("xpoweredBy", Boolean.toString(xPoweredBy));
            jspServlet.addInitParam("displaySourceFragment", Boolean.toString(displaySourceFragment));
            this.servletInfo = jspServlet;
        }
    }

    public ServletInfo createJSPServletInfo() {
        if (this.servletInfo == null) {
            return null;
        }
        return this.servletInfo.clone();
    }
}

