/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.HttpHandler;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Handler;
import org.wildfly.extension.undertow.UndertowMessages;

public class FilterService
implements Service<FilterService> {
    private final Handler handler;
    private final ModelNode model;

    public FilterService(Handler handler, ModelNode model) {
        this.handler = handler;
        this.model = model;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public HttpHandler createHttpHandler(HttpHandler next) {
        Class<? extends HttpHandler> handlerClass = this.handler.getHandlerClass();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>(this.handler.getAttributes());
        int numOfParams = attributes.size() + 1;
        try {
            for (Constructor<?> c : handlerClass.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != numOfParams) continue;
                Object[] params = new Object[numOfParams];
                Class<?>[] parameterTypes = c.getParameterTypes();
                int attrCounter = 0;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> param = parameterTypes[i];
                    if (param == String.class) {
                        params[i] = this.model.get(((AttributeDefinition)attributes.get(attrCounter)).getName()).asString();
                        ++attrCounter;
                        continue;
                    }
                    if (param == Integer.class || param == Integer.TYPE) {
                        params[i] = this.model.get(((AttributeDefinition)attributes.get(attrCounter)).getName()).asInt();
                        ++attrCounter;
                        continue;
                    }
                    if (param == Long.class || param == Long.TYPE) {
                        params[i] = this.model.get(((AttributeDefinition)attributes.get(attrCounter)).getName()).asLong();
                        ++attrCounter;
                        continue;
                    }
                    if (param != HttpHandler.class) continue;
                    params[i] = next;
                }
                return (HttpHandler)c.newInstance(params);
            }
        }
        catch (Throwable e) {
            throw UndertowMessages.MESSAGES.cannotCreateHttpHandler(handlerClass, this.model, e);
        }
        throw UndertowMessages.MESSAGES.cannotCreateHttpHandler(handlerClass, this.model, null);
    }

    public FilterService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

