/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;

public class ReverseProxyHandlerHost
extends PersistentResourceDefinition {
    public static final ReverseProxyHandlerHost INSTANCE = new ReverseProxyHandlerHost();
    public static final ServiceName SERVICE_NAME = UndertowService.HANDLER.append(new String[]{"reverse-proxy", "host"});

    private ReverseProxyHandlerHost() {
        super(PathElement.pathElement((String)"host"), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "reverse-proxy", "host"));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReverseProxyHostAdd add = new ReverseProxyHostAdd();
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(SERVICE_NAME, add){

            protected ServiceName serviceName(String name, PathAddress address) {
                String proxyName = address.getElement(address.size() - 2).getValue();
                return SERVICE_NAME.append(new String[]{proxyName}).append(new String[]{name});
            }
        }, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    private static final class ReverseProxyHostService
    implements Service<ReverseProxyHostService> {
        private final InjectedValue<ProxyHandler> proxyHandler = new InjectedValue();
        private final String name;

        private ReverseProxyHostService(String name) {
            this.name = name;
        }

        public void start(StartContext startContext) throws StartException {
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)((ProxyHandler)this.proxyHandler.getValue()).getProxyClient();
            try {
                client.addHost(new URI(this.name));
            }
            catch (URISyntaxException e) {
                throw new StartException((Throwable)e);
            }
        }

        public void stop(StopContext stopContext) {
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)((ProxyHandler)this.proxyHandler.getValue()).getProxyClient();
            try {
                client.removeHost(new URI(this.name));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public ReverseProxyHostService getValue() throws IllegalStateException, IllegalArgumentException {
            return this;
        }
    }

    private final class ReverseProxyHostAdd
    extends AbstractAddStepHandler {
        private ReverseProxyHostAdd() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            String proxyName = address.getElement(address.size() - 2).getValue();
            ReverseProxyHostService service = new ReverseProxyHostService(name);
            ServiceBuilder builder = context.getServiceTarget().addService(SERVICE_NAME.append(new String[]{proxyName}).append(new String[]{name}), (Service)service).addDependency(UndertowService.HANDLER.append(new String[]{proxyName}), ProxyHandler.class, (Injector)service.proxyHandler);
            if (verificationHandler != null) {
                builder.addListener((ServiceListener)verificationHandler);
            }
            ServiceController controller = builder.install();
            if (newControllers != null) {
                newControllers.add(controller);
            }
        }
    }
}

