/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.Schedulable;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.util.AbstractPoolable;

public abstract class AbstractTask
extends AbstractPoolable
implements Runnable,
Schedulable {
    private TaskExecutor taskExecutor_;

    protected TaskExecutor getTaskExecutor() {
        return this.taskExecutor_;
    }

    protected void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor_ = taskExecutor;
    }

    public abstract void doWork() throws Exception;

    protected boolean isRunnable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.isRunnable()) {
                this.doWork();
            }
        }
        catch (Exception e) {
            this.handleTaskError(this, e);
        }
        finally {
            this.dispose();
        }
    }

    abstract void handleTaskError(AbstractTask var1, Exception var2);

    protected void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected void schedule(boolean directRunAllowed) {
        this.schedule(this.taskExecutor_, directRunAllowed);
    }

    protected void schedule(TaskExecutor executor, boolean directRunAllowed) {
        if (directRunAllowed) {
            this.run();
        } else {
            executor.execute(this);
        }
    }
}

