/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.orb.listener.DefaultAcceptorExceptionListener;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.slf4j.Logger;

public class IIOPListener
extends ListenerBase {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private SocketFactoryManager socketFactoryManager = null;
    private SSLAcceptor sslAcceptor = null;
    private LoopbackAcceptor loopbackAcceptor;
    private boolean supportSSL = false;
    private int serverTimeout = 0;
    private IIOPAddress address = null;
    private IIOPAddress sslAddress = null;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;

    public void configure(Configuration configuration) throws ConfigurationException {
        ProtocolAddressBase addr;
        super.configure(configuration);
        this.socketFactoryManager = this.orb.getTransportManager().getSocketFactoryManager();
        String address_str = configuration.getAttribute("OAAddress", null);
        if (address_str != null) {
            addr = this.orb.createAddress(address_str);
            if (addr instanceof IIOPAddress) {
                this.address = (IIOPAddress)addr;
            }
        } else {
            int oaPort = configuration.getAttributeAsInteger("OAPort", 0);
            String oaHost = configuration.getAttribute("OAIAddr", "");
            this.address = new IIOPAddress(oaHost, oaPort);
        }
        if (this.address != null) {
            this.address.configure(configuration);
        }
        if ((address_str = configuration.getAttribute("OASSLAddress", null)) != null) {
            addr = this.orb.createAddress(address_str);
            if (addr instanceof IIOPAddress) {
                this.sslAddress = (IIOPAddress)addr;
            }
        } else {
            int sslPort = configuration.getAttributeAsInteger("OASSLPort", 0);
            String sslHost = configuration.getAttribute("OAIAddr", "");
            this.sslAddress = new IIOPAddress(sslHost, sslPort);
        }
        if (this.sslAddress != null) {
            this.sslAddress.configure(configuration);
        }
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttribute("jacorb.security.ssl_components_added_by_ior_interceptor", "off").equals("off");
        if (!this.isSSLRequired() || configuration.getAttributeAsBoolean("jacorb.security.ssl.always_open_unsecured_address", false)) {
            this.acceptor = new Acceptor("ServerSocketListener");
            ((Acceptor)this.acceptor).init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.loopbackAcceptor = new LoopbackAcceptor();
        this.profile = this.createAddressProfile();
    }

    public void listen() {
        super.listen();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
        this.loopbackAcceptor.start();
    }

    public void destroy() {
        this.loopbackAcceptor.terminate();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        super.destroy();
    }

    public void renewSSLServerSocket() {
        if (this.sslAcceptor != null) {
            this.sslAcceptor.renewSSLServerSocket();
        }
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private IIOPProfile createAddressProfile() throws ConfigurationException {
        if (this.acceptor != null) {
            if (this.address.getPort() == 0) {
                this.address.setPort(((Acceptor)this.acceptor).getLocalAddress().getPort());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using port " + this.address.getPort());
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create address profile");
        }
        IIOPProfile result = new IIOPProfile(this.address, null);
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            result.addComponent(20, this.createSSL(), SSLHelper.class);
        }
        result.configure(this.configuration);
        return result;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private void deliverConnection(Socket socket, boolean isSSL) {
        Connection result = null;
        try {
            result = this.createServerConnection(socket, isSSL);
        }
        catch (IOException ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: ", (Throwable)ex);
            }
            return;
        }
        this.deliverConnection(result);
    }

    protected Connection createServerConnection(Socket socket, boolean is_ssl) throws IOException {
        TCPConnectionListener tcpListener = this.socketFactoryManager.getTCPListener();
        ServerIIOPConnection result = new ServerIIOPConnection(socket, is_ssl, tcpListener);
        if (tcpListener.isListenerEnabled()) {
            tcpListener.connectionOpened(new TCPConnectionEvent(result, socket.getInetAddress().getHostAddress(), socket.getPort(), socket.getLocalPort(), this.getLocalhost()));
        }
        try {
            result.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            throw new INTERNAL("ConfigurationException: " + ce.toString());
        }
        return result;
    }

    private String getLocalhost() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
            }
            localhost = "127.0.0.1";
        }
        return localhost;
    }

    static /* synthetic */ Logger access$700(IIOPListener x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$800(IIOPListener x0) {
        return x0.logger;
    }

    private class LoopbackAcceptor
    implements IIOPLoopback {
        private LoopbackAcceptor() {
        }

        public void start() {
            IIOPLoopbackRegistry.getRegistry().register(this.getAddress(), this);
        }

        public void terminate() {
            IIOPLoopbackRegistry.getRegistry().unregister(this.getAddress());
        }

        public void initLoopback(IIOPLoopbackInputStream lis, IIOPLoopbackOutputStream los) {
            IIOPLoopbackConnection connection = new IIOPLoopbackConnection(lis, los);
            try {
                connection.configure(IIOPListener.this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INTERNAL("ConfigurationException: " + ce.toString());
            }
            IIOPListener.this.deliverConnection(connection);
        }

        private IIOPAddress getAddress() {
            IIOPProfile profile = (IIOPProfile)IIOPListener.this.profile;
            return (IIOPAddress)profile.getAddress();
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private final Object renewSocketSync;
        private boolean renewingSocket;
        private boolean blockedOnAccept;
        private final int soTimeout;

        private SSLAcceptor() {
            super("SSLServerSocketListener");
            this.renewSocketSync = new Object();
            this.soTimeout = IIOPListener.this.configuration.getAttributeAsInteger("jacorb.listener.server_socket_timeout", 0);
        }

        protected ServerSocket createServerSocket() {
            try {
                int port = IIOPListener.this.sslAddress.getPort();
                InetAddress configuredHost = IIOPListener.this.sslAddress.getConfiguredHost();
                ServerSocket socket = this.newServerSocket(port, configuredHost);
                return socket;
            }
            catch (IOException e) {
                IIOPListener.this.logger.warn("could not create SSL server socket", (Throwable)e);
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        private ServerSocket newServerSocket(int port, InetAddress configuredHost) throws IOException {
            ServerSocket socket = IIOPListener.this.socketFactoryManager.getSSLServerSocketFactory().createServerSocket(port, 20, configuredHost);
            if (this.soTimeout > 0) {
                this.serverSocket.setSoTimeout(this.soTimeout);
            }
            return socket;
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beginAccept() throws InterruptedException {
            Object object = this.renewSocketSync;
            synchronized (object) {
                while (this.renewingSocket) {
                    this.renewSocketSync.wait();
                }
                this.blockedOnAccept = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void endAccept() {
            Object object = this.renewSocketSync;
            synchronized (object) {
                this.blockedOnAccept = false;
                this.renewSocketSync.notifyAll();
            }
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean isTerminated) {
            if (!(exception instanceof InterruptedException)) {
                return;
            }
            if (this.soTimeout > 0) {
                return;
            }
            if (isTerminated) {
                return;
            }
            IIOPListener.this.logger.warn("InterruptedException should only occur if soTimeout > 0", (Throwable)exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewSSLServerSocket() {
            Object object;
            int oldPort = this.serverSocket.getLocalPort();
            InetAddress oldAddress = this.serverSocket.getInetAddress();
            try {
                object = this.renewSocketSync;
                synchronized (object) {
                    this.renewingSocket = true;
                    while (this.blockedOnAccept) {
                        try {
                            this.renewSocketSync.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception e) {
                    IIOPListener.this.logger.warn("failed to close SSLServerSocket", (Throwable)e);
                }
                try {
                    this.serverSocket = this.newServerSocket(oldPort, oldAddress);
                }
                catch (Exception e) {
                    IIOPListener.this.logger.warn("Failed to create SSLServerSocket", (Throwable)e);
                    throw new INITIALIZE("Could not create SSL server socket: " + e);
                }
            }
            finally {
                object = this.renewSocketSync;
                synchronized (object) {
                    this.renewingSocket = false;
                    this.renewSocketSync.notifyAll();
                }
            }
        }
    }

    public class Acceptor
    extends ListenerBase.Acceptor {
        private final Object runSync = new Object();
        private final boolean keepAlive;
        protected ServerSocket serverSocket;
        protected boolean terminated = false;
        private final AcceptorExceptionListener acceptorExceptionListener;
        private boolean firstPass;

        protected Acceptor(String name) {
            this.setDaemon(true);
            this.setName(name);
            this.keepAlive = IIOPListener.this.configuration.getAttributeAsBoolean("jacorb.connection.server.keepalive", false);
            try {
                this.acceptorExceptionListener = (AcceptorExceptionListener)IIOPListener.this.configuration.getAttributeAsObject("jacorb.acceptor_exception_listener", DefaultAcceptorExceptionListener.class.getName());
            }
            catch (ConfigurationException e) {
                IIOPListener.this.logger.error("couldn't create a AcceptorExceptionListener", (Throwable)e);
                throw new IllegalArgumentException("wrong configuration: " + e);
            }
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort());
            }
        }

        protected void beginAccept() throws InterruptedException {
        }

        protected void endAccept() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public final void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        var1_1 = this.runSync;
                        synchronized (var1_1) {
                            if (this.terminated) {
                                if (IIOPListener.access$700(IIOPListener.this).isInfoEnabled()) {
                                    IIOPListener.access$800(IIOPListener.this).info("Listener exited");
                                }
                                return;
                            }
                        }
                        this.beginAccept();
                        try {
                            socket = this.serverSocket.accept();
                            this.setup(socket);
                            this.deliverConnection(socket);
                            this.firstPass = true;
                        }
                        finally {
                            this.endAccept();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    var2_3 = this.runSync;
                    synchronized (var2_3) {
                        this.handleExceptionInRunLoop(e, this.terminated);
                        continue;
                    }
                }
                ** GOTO lbl-1000
            }
        }

        private void handleExceptionInRunLoop(Exception exception, boolean isTerminated) {
            if (!isTerminated) {
                IIOPListener.this.logger.warn("unexpected exception in runloop", (Throwable)exception);
            }
            this.acceptorExceptionListener.exceptionCaught(new AcceptorExceptionEvent(this, ((BasicAdapter)IIOPListener.this.up).getORB(), exception));
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean isTerminated) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            block5: {
                Object object = this.runSync;
                synchronized (object) {
                    this.terminated = true;
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block5;
                    IIOPListener.this.logger.warn("failed to close ServerSocket", (Throwable)e);
                }
            }
            this.interrupt();
        }

        public IIOPAddress getLocalAddress() {
            IIOPAddress addr;
            block3: {
                addr = new IIOPAddress(this.serverSocket.getInetAddress().toString(), this.serverSocket.getLocalPort());
                if (IIOPListener.this.configuration != null) {
                    try {
                        addr.configure(IIOPListener.this.configuration);
                    }
                    catch (ConfigurationException ce) {
                        if (!IIOPListener.this.logger.isWarnEnabled()) break block3;
                        IIOPListener.this.logger.warn("ConfigurationException", (Throwable)ce);
                    }
                }
            }
            return addr;
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.socketFactoryManager.getServerSocketFactory().createServerSocket(IIOPListener.this.address.getPort(), 20, IIOPListener.this.address.getConfiguredHost());
            }
            catch (IOException ex) {
                IIOPListener.this.logger.warn("could not create server socket port: " + IIOPListener.this.address.getPort() + " host: " + IIOPListener.this.address.getConfiguredHost(), (Throwable)ex);
                throw new INITIALIZE("Could not create server socket (" + IIOPListener.this.address.getPort() + "): " + ex.toString());
            }
        }

        protected final void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
            socket.setKeepAlive(this.keepAlive);
            socket.setTcpNoDelay(true);
            SSLListenerUtil.addListener(IIOPListener.this.orb, socket);
            this.doSetup(socket);
        }

        protected void doSetup(Socket socket) {
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }

        public boolean getAcceptorSocketLoop() {
            return this.firstPass;
        }
    }
}

