/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrArtifactFilter
implements ArtifactFilter {
    private Set<ArtifactFilter> filters;

    public OrArtifactFilter() {
        this.filters = new LinkedHashSet<ArtifactFilter>();
    }

    public OrArtifactFilter(Collection<ArtifactFilter> filters) {
        this.filters = new LinkedHashSet<ArtifactFilter>(filters);
    }

    public boolean include(Artifact artifact) {
        for (ArtifactFilter filter : this.filters) {
            if (!filter.include(artifact)) continue;
            return true;
        }
        return false;
    }

    public void add(ArtifactFilter artifactFilter) {
        this.filters.add(artifactFilter);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.filters.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrArtifactFilter)) {
            return false;
        }
        OrArtifactFilter other = (OrArtifactFilter)obj;
        return this.filters.equals(other.filters);
    }
}

